<?php
/*
Plugin Name: (Q8) Core
Version: 2.0
Author: Q8
Description: Core modules
*/
( @__DIR__ == '__DIR__' ) && define( '__DIR__', realpath( dirname(__FILE__) ) );

if (!function_exists('add_action')) { header('Status: 403 Forbidden'); header('HTTP/1.1 403 Forbidden'); exit("This page can't be loaded outside of WordPress!"); }
global $wp_version;
if (version_compare($wp_version, "3.5.2", "<")) { exit("<b>CPC Tweets</b> requires WordPress 3.5.2 OR newer. <a href=\"http:/codex.wordpress.org/Upgrading_WordPress\">Please update!</a>"); }

function plugin_activation_check(){ 

        if (version_compare(phpversion(), '5.2.4', '<')) { 

                deactivate_plugins(basename(__FILE__)); // Deactivate ourself 

                wp_die("Sorry, but you can't run this plugin, it requires PHP 5.2.4 or higher."); 

        } 

} 

register_activation_hook(__FILE__, 'plugin_activation_check');

define( "Q8_CORE_ACTIVE_FLAG", true );
define(	"Q8_CORE_URL", WP_PLUGIN_URL."/".plugin_basename( dirname( __FILE__ ) ) );	
define( "Q8_CORE_DIR", plugin_dir_path( __FILE__ ) );

/**
 *	COMMON FUNCTIONS
 */
function q8_french_enabled() { global $q_config; if ($q_config['language']) { return true; } return false; }
function q8_translate($en=NULL,$fr=NULL) { global $q_config; $text = $en; if ("fr" == $q_config["language"]) { $text = $fr; } return $text; }
function q8_clean_post( $p ) { $p = strip_tags($p); $p = stripslashes($p); $p = trim($p); return $p; }
function q8_save_postdata($post_id, $n, $v) { if('' == trim($v) || '0' == trim($v)) { delete_post_meta($post_id, $n); } else { update_post_meta($post_id, $n, $v); } }
function main_excerpt($content) { $content = str_replace("[...]", "...", $content); return $content; }

/*
 *	@func  		q8_mail_headers
 * 	@params 	<send_from_name:string, send_from_email:string>
 * 	@returns 	headers prepared appropraitely. 
 */
function q8_mail_headers($send_from_name, $send_from_email) {
	$headers = "From: {$send_from_email}"."\r\n";
	$headers .= "Reply-To: {$send_from_email}"."\r\n";
	$headers .= "Return-path: {$send_from_email}\n";
	$headers .= "X-Mailer:PHP".phpversion()."\r\n";
	$headers .= "Precedence: list\nList-Id: ".@get_option('blogname')."\r\n";
	$headers .= "MIME-Version: 1.0\n";
	$headers .= "Content-Type: text/html; charset=\"".@get_bloginfo('charset')."\""."\r\n";
	return $headers;
}
/*
 *	@func 		q8_get_email_addresses
 * 	@params 	<ns:string, es:string>
 *  @returns 	Array, to and cc keys.
 */
function q8_get_email_addresses($ns,$es) 
{
	$n = explode(",",$ns); $e = explode(",",$es);
	if (count($e) > 1) {
		$temp["to"] = trim(addslashes($name[0]))."<".trim($e[0]).">";
		for ($x = 1; $x < count($e); $x++) { $temp["cc"] .= trim(addslashes($n[$x]))."<".trim($e[$x]).">,"; }
		$temp["cc"] = substr($temp["cc"],0,-1);
		$temp["cc"] = "Cc: " . $temp["cc"] . "\n";
	}
	else { $temp["to"] = trim($e[0]); $temp["cc"] = NULL; }
	return $temp;
}
/*
 *	@func 		q8_verify_email_addresses
 *	@params 	<es:string> contains either email or comma separated list of emails
 * 	@returns 	bolean 
 */
function q8_verify_email_addresses($es) 
{
	$temp = true;
	$e = explode(",",$es);
	if (count($e) > 1) { for ($x = 0; $x < count($e); $x++) { if (!@is_email($e[$x])) $temp = false;	} }
	else { if (!@is_email($e[0])) $temp = false; }
	return $temp;
}

/*
 *	@func 		q8_get_youtube_id
 *	@params 	<yt_link:string>
 * 	@returns 	<void> 
 */
function q8_get_youtube_id( $yt_link )
{
	return preg_replace( '~
		# Match non-linked youtube URL in the wild. (Rev:20130823)
		https?://         # Required scheme. Either http or https.
		(?:[0-9A-Z-]+\.)? # Optional subdomain.
		(?:               # Group host alternatives.
		  youtu\.be/      # Either youtu.be,
		| youtube\.com    # or youtube.com followed by
		  \S*             # Allow anything up to VIDEO_ID,
		  [^\w\-\s]       # but char before ID is non-ID char.
		)                 # End host alternatives.
		([\w\-]{11})      # $1: VIDEO_ID is exactly 11 chars.
		(?=[^\w\-]|$)     # Assert next char is non-ID or EOS.
		(?!               # Assert URL is not pre-linked.
		  [?=&+%\w.-]*    # Allow URL (query) remainder.
		  (?:             # Group pre-linked alternatives.
		    [\'"][^<>]*>  # Either inside a start tag,
		  | </a>          # or inside <a> element text contents.
		  )               # End recognized pre-linked alts.
		)                 # End negative lookahead assertion.
		[?=&+%\w.-]*        # Consume any URL (query) remainder.
		~ix', 
		'$1',
		$yt_link );
}

/*
 *	@func 		q8_css
 *	@params 	<void>
 * 	@returns 	<void> 
 */
function q8_css() { if (is_admin()) { wp_enqueue_style('q8_core_css',Q8_CORE_URL.'/css/q8.core.css'); } }

add_action( "admin_print_styles", 'q8_css' );

/**
 *	Q8 BLOCK and DEPENDANCIES
 */

if ( !class_exists( 'Q8_BLOCK' ) ):
class Q8_BLOCK {

	var $arr = array();
	/**
	 *	@function	draw_block
	 *	@params 	<title:string>,<version:string>,<description:string>,<footer:string>
	 *	@return 	<void>
	 */
	public function draw_block($title,$version=NULL,$description=NULL,$footer=NULL){
		?>
		<div class="wrap">
       		<div class="q8_block">
            	<div class="header">
            		<h2><?php echo $title; ?> <small><?php echo $version; ?></small></h2>
            		<div class="description">
            			<p><?php echo $description; ?></p>
            		</div>
            	</div>
            	<div class="body">
            		<div class="nav">
            			<ul>
            				<?php echo $this->create_navigation(); ?>
            			</ul>
            		</div>
            		<div class="content">
            			<?php echo $this->create_tab_block(); ?>
            		</div>
            	</div>
            	<div class="footer">
            		<p><?php echo $footer; ?></p>
            	</div>
            </div>
        </div>
        <?php
	}
	/**
	 *	@function	add_tab
	 *	@params 	<id:string>,<title:string>,<callback:array>
	 *	@return 	<void>
	 */
	public function add_tab($id,$title,$callback){
		$this->arr[] = array('id'=>$id,'title'=>$title,'callback'=>$callback);
	}
	/**
	 *	@function	create_navigation
	 *	@params 	<void>
	 *	@return 	<li:string>
	 */
	private function create_navigation() {
		$arr = $this->arr;
		foreach($arr as $a):
			$li .= '<li><a href="#'.$a['id'].'">'.$a['title'].'</a></li>';
		endforeach;
		return $li;
	}

	/**
	 *	@function	create_tab_block
	 *	@params 	<void>
	 *	@return 	<tab_block:string>
	 */
	private function create_tab_block() {
		$arr = $this->arr;
		$i=0;
		foreach($arr as $a): 
			$i++;
			ob_start();
			call_user_func($a['callback']);
			$callback = ob_get_contents();
			ob_end_clean();
			$tab_block .= '<div id="'.$a['id'].'" class="panel">'.$callback.'</div>';
		endforeach;
		return $tab_block;
	}

	public static function css() { if (is_admin()) { wp_enqueue_style('q8_block_css',Q8_CORE_URL.'/css/q8.block.css'); } }
	public static function js() { if (is_admin()) { wp_enqueue_script('q8_block_js',Q8_CORE_URL.'/scripts/q8.block.js'); } }
}
endif;

add_action( "admin_print_styles", array( 'Q8_BLOCK', "css" ) );
add_action( "admin_print_scripts", array( 'Q8_BLOCK', "js" ) );



/**
 *	Q8 RENDERER and DEPENDANCIES
 */
if ( !class_exists( 'Q8_RENDER' ) ):
class Q8_RENDER
{

	/**
	 *	@function 		render
	 *	@params 		<path:string> path to template folder
	 *					<data:array> data to be rendered with the template
	 *					<name:string> file name (default: "theme")
	 *					<options:array> optional parameters:
	 *						<suffix:string> file suffix (extension)
	 *	@returns 		<string> rendered template <string> or empty <string> on failure
	 */
	public static function render( $path, $data, $name = "theme", $options = array( "suffix" => ".blade.php" ) )
	{
		if ( empty( $path ) )
			return;

		if ( !empty( $name ) )
			$template = $name;
		else
			$template = "theme";
		
		$template_suffix = $options["suffix"];

		$filename;

		if ( !is_null( $template ) )
		{
			$file = $path."/".$template.$template_suffix;
			if ( is_file( $file ) )
			{
				extract( $data );
				ob_start( );
				$view = Blade::rewrite( file_get_contents( $file ) );
				try { eval( '?>'.$view ); } catch ( Exception $e ) { return " "; }
				return ob_get_clean( );
			}
		}

		return "";
	}
}
endif;

/**
 *	Blade Microtemplating language
 */
if ( !class_exists( 'Blade' ) ):
class Blade {

	/**
	 * Rewrites the specified string containing Blade pseudo-code
	 * into valid PHP code.
	 *
	 * @param  string  $value
	 * @return string
	 */
	public static function rewrite($value)
	{
		$value = self::rewrite_echos($value);
		$value = self::rewrite_openings($value);
		$value = self::rewrite_closings($value);

		return $value;
	}

	/**
	 * Rewrites Blade echo statements into PHP echo statements.
	 *
	 * @param  string  $value
	 * @return string
	 */
	private static function rewrite_echos($value)
	{
		return preg_replace('/\{\{(.+)\}\}/', '<?php echo $1; ?>', $value);
	}

	/**
	 * Rewrites Blade structure openings into PHP structure openings.
	 *
	 * @param  string  $value
	 * @return string
	 */
	private static function rewrite_openings($value)
	{
		return preg_replace('/@(if|foreach|for|while)(.*)/', '<?php $1$2: ?>', $value);
	}

	/**
	 * Rewrites Blade structure closings into PHP structure closings.
	 *
	 * @param  string  $value
	 * @return string
	 */
	private static function rewrite_closings($value)
	{
		$value = preg_replace('/(\s*)@(else|elseif)(.*)/', '$1<?php $2$3: ?>', $value);
		$value = preg_replace('/^(\s*)@(endif|endforeach|endfor|endwhile)(\s*)$/m', '$1<?php $2; ?> $3', $value);

		return $value;
	}
}
endif;

/**
 *	ENGINES ( TWIG AND GA INJECTOR )
 */

include_once __DIR__."/engine.twig.php";
include_once __DIR__."/engine.injector.php";
include_once __DIR__."/engine.metaboxes.php";

/**
 *	PANEL TEMPLATES
 */

/**
 *	@func 		panel_theme
 *	@params 	<void>
 *	@returns 	<void>
 */
function q8_panel_theme( $option ) 
{
	$twig = q8_new_twig_engine( Q8_CORE_DIR."templates/" );

	$template = array( );
	$template["hidden_field_name"] = md5( "q8_theme" );

	if( isset( $_POST[$template["hidden_field_name"]] ) ) 
	{
		$theme_name = @q8_clean_post( $_POST["q8_theme"] );
		if( $theme_name ) 
		{
			update_option( $option, array( "theme_name" => $theme_name ) );
			$template["msg"] = "<div class=\"alert alert-success\"><p>Theme name settings have been updated.</p></div>";
		} 
		else 
		{
			delete_option( $option );
			$template["msg"] = "<div class=\"alert alert-success\"><p>Theme name settings have been removed.</p></div>";
		}
	}

	$template["setting"] = get_option( $option );

	echo $twig->render( "panel.core.theme.twig.html", $template );
}

/**
 *	@func 		panel_schedule
 *	@params 	<void>
 *	@returns 	<void>
 */
function q8_panel_schedule( $hook )
{
	putenv( "TZ=US/Eastern" );
	$timestamp = wp_next_scheduled( $hook );
	$scheduled_time = date( "l, F j, Y @ g:i A T", $timestamp );
	$current_time = date( "l, F j, Y @ g:i A T", ( time( ) - 14400 ) );
	?>
    <div class="blurb">The next update is scheduled to perform on <b><?php echo $scheduled_time; ?></b>. The current time is <b><?php echo $current_time; ?></b>.</div>
	<?php
}

?>