<?php /* TEMPLATE NAME: CONTACT */ ?>
<?php global $MPWP; ?>
<?php get_header(); ?>

<!-- /////////////////// MAIN CONTENT \\\\\\\\\\\\\\\\\\\\\-->

	<section class="row main_content">

		<div class="container"><?php echo @$MPWP->get_hot_topics(); ?></div>

		<div class="contact page col-md-8 no_padding border bg">
			<article class="post-full">
				<header>
					<?php global $post; if (have_posts()) : the_post(); ?>
					<h1><?php the_title(); ?></h1>
				</header>
				<?php the_content( ); ?>
				<br />
				<?php
					$settings = get_option( $MPWP->theme_mp_map_settings );
					$hill_contact = get_option( $MPWP->theme_mp_contact_info );
					$constit = get_option( $MPWP->theme_mp_map_offices );
				?>
				<?php if ( "interactive" === $settings["map_type"] ): ?>
					<div id="google-maps-canvas" style="display:block; width:100%; height:300px; border:1px solid #ccc;"></div>
					<script src="//maps.googleapis.com/maps/api/js?key=<?php echo $settings["google_maps_id"]; ?>&amp;sensor=false" type="text/javascript"></script>
					<script type="text/javascript">
						jQuery( function( ) {
							var mapOptions = {
								"center": new google.maps.LatLng(65, -94),
								"zoom": 4,
								"mapTypeId": google.maps.MapTypeId.ROADMAP 
							};

							var map = new google.maps.Map( document.getElementById( "google-maps-canvas" ), mapOptions );

							var KmlLayer = new google.maps.KmlLayer( "http://cpcweb.ca/demo/pomona/parliament/41/<?php echo RIDING_ID; ?>.kml", { "map": map } );
							KmlLayer.setMap( map );

							var infoWindow = new google.maps.InfoWindow( { "content":"" } );

							var markers = [];
							<?php if ( !empty( $constit ) ): foreach( $constit as $index => $marker ): ?>
							markers[<?php echo $index; ?>] = new google.maps.Marker( {
								"position": new google.maps.LatLng( <?php echo $marker->location->lat; ?>, <?php echo $marker->location->lng; ?> ),
								"map": map,
								"title": jQuery( "#<?php echo str_replace( " ", "", $marker->postalcode ); ?> .office-title" ).text( ),
								"icon": "<?php echo $settings["pin_style"]; ?>",
								"html": "<div style=\"min-height:100px; width:250px;\">"+jQuery( "#<?php echo str_replace( " ", "", $marker->postalcode ); ?>" ).html( )+"</div>"
							} );
							google.maps.event.addListener( markers[<?php echo $index; ?>], "click", function( ) {
								infoWindow.setContent( this.html );
								infoWindow.open( map, this );
							});
							<?php endforeach; endif; ?>
						} );
					</script>
					<?php else: ?>
						<img src="<?php echo ASSET_URL; ?>parliament/41/<?php echo RIDING_ID; ?>.gif" alt="Riding Map" /><p>&nbsp;</p>
					<?php endif; ?>
					
					<?php if ( !empty( $hill_contact->hillphone ) || !empty( $hill_contact->hillfax ) || !empty( $hill_contact->email ) ): ?>
						<div id="hill-contact">
							<h2><?php echo @q8_translate( "Ottawa Office", "Coordonnées du bureau au Parlement" ); ?></h2>
							<hr>
							<?php if ( !empty( $hill_contact->hillphone ) ): ?><p><b><?php echo @q8_translate( "Phone Number", "Numéro de téléphone" ); ?>:</b> <?php echo $hill_contact->hillphone; ?></p><?php endif; ?>
							<?php if ( !empty( $hill_contact->hillfax ) ): ?><p><b><?php echo @q8_translate( "Fax Number", "Numéro de fax" ); ?>:</b> <?php echo $hill_contact->hillfax; ?></p><?php endif; ?>
							<?php if ( !empty( $hill_contact->email ) ): ?><p><b><?php echo @q8_translate( "E-mail Address", "Courriel" ); ?>:</b> <?php echo $hill_contact->email; ?></p><?php endif; ?>
						</div>
					<?php endif; ?>
					
					<?php if ( !empty( $constit ) ): ?>
						<br>
						<div id="constit-contact">
							<h2><?php echo @q8_translate( "Regina Office", "Coordonnées du bureau de circonscription" ); ?></h2>
							<hr>
							<?php foreach( $constit as $office ): ?>
							<div id="<?php echo str_replace( " ", "", $office->postalcode ); ?>">
								<!--<h3 class="office-title"><?php echo @q8_translate( $office->city." Regina Office", "Bureau de circonscription à ".$office->city ); ?></h3>-->
								<p><b><?php echo @q8_translate( "Address", "Adresse" ); ?>:</b><br /><?php echo $office->suite; ?><?php echo $office->address; ?><br /><?php echo $office->city; ?>, <?php echo $office->province; ?><br /><?php echo $office->postalcode; ?></p>
								<?php if ( !empty( $office->phone ) ): ?><p><b><?php echo @q8_translate( "Phone Number", "Numéro de téléphone" ); ?>:</b> <?php echo $office->phone; ?></p><?php endif; ?>
								<?php if ( !empty( $office->fax ) ): ?><p><b><?php echo @q8_translate( "Fax Number", "Numéro de fax" ); ?>:</b> <?php echo $office->fax; ?></p><?php endif; ?>
							</div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			</article> <!-- post-full -->
			<?php echo @$MPWP->contact_form( ); ?>
		
		</div> <!-- contact page col-md-8 no_padding border bg -->

		<?php get_sidebar(); ?>
	
	</section> <!-- row main_content -->

<hr>

<?php get_footer(); ?>
