<?php /* TEMPLATE NAME: NEWS  */ ?>
<?php get_header(); ?>

<!-- /////////////////// MAIN CONTENT \\\\\\\\\\\\\\\\\\\\\-->

	<div class="row main_content">
		<div class="container"><?php echo @$MPWP->get_hot_topics(); ?></div>
		<section class="col-md-8 no_padding border">
			<?php global $post; if (have_posts()) : the_post(); ?>
		
		<h1><?php the_title(); ?></h1>
		<?php the_content(); ?>
		<?php endif; ?>
		<?php
		$cat_array = @$MPWP->categories["news-riding"].",".@$MPWP->categories["news-government"];
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1; 
		$query = new WP_Query( array(
			'category_name'=>$cat_array,
			'paged'=>$paged,
			'orderby'=>'date',
			'order'=>'DESC'
		) );
		while ($query->have_posts()) : $query->the_post();
			$e=@$MPWP->the_excerpt(get_the_excerpt(),250);
			$link = get_permalink();
			$img = @$MPWP->get_news_image($query->post->ID);
			$img_hidden_phone = ($img) ? '<div class="img hidden-phone"><img src="'.$img.'" /></div>' : NULL;
			$img_visible_phone = ($img) ? '<span class="img"><img src="'.$img.'" class="left" /></span>' : NULL;
		?>
			<article class="news_item bg">
				<header class="news_title_wrapper">
					<h1><a href="<?php echo $link; ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a></h1>
					<time><?php echo get_the_date(); ?></time>
				</header>
				<?php if (isset($img)){?>
					<span class="img">
						<a href="<?php echo $link; ?>" title="<?php the_title_attribute(); ?>"><img src="<?php echo $img ?>" class="left" /></a>
					</span>
				<?php } ?>
				<p>
					<?php echo $e; ?>
					<a href="<?php echo $link; ?>">
						<span class="news_article_link"><?php echo @q8_translate("Full Article","Article int&eacute;gral"); ?></span>
					</a>
				</p>
				<div class="clearfix"></div>
				<?php echo @$MPWP->get_socialtools( $link,true ); ?>
			</article> <!-- news_item bg -->
		<?php endwhile;?>
			<ul class="pager"> 
				<li class="previous"><?php next_posts_link( '&larr; '.@q8_translate("Older Articles","Articles plus vieux"), $query->max_num_pages); ?></li>
				<li class="next"><?php previous_posts_link( @q8_translate("Newer Articles","Articles plus rcents").' &rarr;', $query->max_num_pages); ?></li>
			</ul>
		<?php wp_reset_postdata(); ?>
		</section>  <!-- col-md-8 no_padding border -->

		<?php get_sidebar(); ?>
	
	</div> <!-- row main_content -->
<hr>

<?php get_footer(); ?>