<?php

class MPWP_Widget extends WP_Widget
{
	var $langs = array();
	
	public function __construct(  ) 
	{
		$this->langs = (@q8_french_enabled()) ? array( 'en', 'fr' ) : array( 'en' );
	}
	
	
	function translate($en=NULL,$fr=NULL) { global $q_config; $text = $en; if ($q_config['language'] == "fr") { $text = $fr; } return $text; }
}

class Code_Widget extends MPWP_Widget 
{
	public function __construct(  ) 
	{
		parent::__construct();
		WP_Widget::__construct(
			'codewidget',
			__('Insert your text'),
			array( 'description' => __('Embed your code or snippet'), 'classname' => 'widget_codewidget'),
			array( )
		);
	}

	public function form( $instance ) 
	{
		$template = $field = array( );
		$instance = wp_parse_args( (array) $instance, array('title_en'=>'','text_en'=>'','title_fr'=>'','text_fr'=>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]    = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]  = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"] = strip_tags($instance['title_'.$lang]);
			$field[$lang]["text"]["id"]     = $this->get_field_id('text_'.$lang);
			$field[$lang]["text"]["name"]   = $this->get_field_name('text_'.$lang);
			$field[$lang]["text"]["value"]  = trim($instance['text_'.$lang]);
		endforeach;
		$template["langs"] = $this->langs;
		$template["field"] = $field;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.code.twig.html',$template);
	}

	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
			$i['text_'.$lang] =  $n['text_'.$lang];
		endforeach;
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		$text = apply_filters('widget_text',  @$this->translate($instance['text_en'],$instance['text_fr']), $instance );
		$template["before_widget"] = $before_widget;
		$template["before_title"] = $before_title;
		$template["title"] = apply_filters('widget_title', @q8_translate(empty($instance['title_en']),empty($instance['title_fr'])) ? '' : @q8_translate($instance['title_en'],$instance['title_fr']), $instance );
		$template["after_title"] = $after_title;
		ob_start();
		eval('?>'.$text);
		$template["text"] = ob_get_contents();
		ob_end_clean();
		$template["after_widget"] = $after_widget;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.code.twig.html',$template);
		}
	}
}

class MPWP_SocialNetworks extends MPWP_Widget 
{
	var $socnet_types = array("facebook","twitter","flickr","youtube","rss","digg","linkedin","delicious","vimeo");

	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'socialnetworks',
			__('Social Networks'),
			array( 'description' => __('Display my online networks'), 'classname' => 'widget_socialnetworks'),
			array( )
		);
	}
	
	public function form( $instance )
	{
		$template = $field = array(  );
		$instance = wp_parse_args((array) $instance, array('title_en'=>'','title_fr'=>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]    = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]  = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"] = strip_tags($instance['title_'.$lang]);
		endforeach;
		foreach ($this->socnet_types as $socnet_type):
			$field[$socnet_type]["id"]    = $this->get_field_id('socnet_'.$socnet_type);
			$field[$socnet_type]["name"]  = $this->get_field_name('socnet_'.$socnet_type);
			$field[$socnet_type]["value"] = format_to_edit($instance['socnet_'.$socnet_type]);
		endforeach;
		$template["field"]        = $field;
		$template["socnet_types"] = $this->socnet_types;
		$template["langs"]        = $this->langs;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.socialnetworks.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
		endforeach;
		foreach ($this->socnet_types as $socnet_type): $i['socnet_'.$socnet_type] = $n['socnet_'.$socnet_type]; endforeach;
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		foreach ($this->socnet_types as $socnet_type):
			if ($instance['socnet_'.$socnet_type]) {
				$links .= '<a href="'.$instance['socnet_'.$socnet_type].'" target="_blank" rel="nofollow" class="socnet_icon '.$socnet_type.'_icon"></a>';
			}
		endforeach;
		$template["before_widget"] = $before_widget;
		$template["before_title"]  = $before_title;
		$template["title"]         = apply_filters('widget_title', @q8_translate(empty($instance['title_en']),empty($instance['title_fr'])) ? '' : @q8_translate($instance['title_en'],$instance['title_fr']), $instance);
		$template["links"] = $links;
		$template["after_title"]   = $after_title;
		$template["after_widget"]  = $after_widget;

		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.socialnetworks.twig.html',$template);
		}
	}
}

class MPWP_RecentNews extends MPWP_Widget 
{
	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'recentnews',
			__('Recent Riding News'),
			array( 'description' => __('Display my recent local articles'), 'classname' => 'widget_recentnews'),
			array( )
		);
	}

	public function form( $instance )
	{
		$template = $field = array(  );
		$instance = wp_parse_args((array) $instance, array('title_en'=>'','title_fr'=>'','quantity' =>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]    = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]  = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"] = strip_tags($instance['title_'.$lang]);
		endforeach;
		$field["quantity"]["id"]    = $this->get_field_id('quantity');
		$field["quantity"]["name"]  = $this->get_field_name('quantity');
		$field["quantity"]["value"] = format_to_edit($instance['quantity']);
		$template["field"] = $field;
		$template["langs"] = $this->langs;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.recentnews.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
		endforeach;
		$i['quantity'] = $n['quantity'];
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		$quantity = (!$instance['quantity']) ? 5 : $instance['quantity'];
		$args = array("category_name" => "news-riding", "posts_per_page" => $quantity, "orderby" => "date", "order" => "DESC");
		$query = new WP_Query($args);
		if ( $query->have_posts() ) : 
			$template["posts"] = array( );
			$x = 0;
			while ($query->have_posts()) :
				$query->the_post();
				$template["posts"][$x]["link"] = get_permalink();
				$template["posts"][$x]["title"] = get_the_title();
				$x++;
			endwhile; 
		endif; wp_reset_postdata();
		$template["before_widget"] = $before_widget;
		$template["before_title"]  = $before_title;
		$template["title"]         = apply_filters('widget_title', @q8_translate(empty($instance['title_en']),empty($instance['title_fr'])) ? '' : @q8_translate($instance['title_en'],$instance['title_fr']), $instance);
		$template["after_title"]   = $after_title;
		$template["after_widget"]  = $after_widget;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.recentnews.twig.html',$template);
		}
	}
}

class MPWP_Promos extends MPWP_Widget 
{
	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'promos',
			__('Promotional Graphic / Link'),
			array( 'description' => __('Highlight an Economic Action Plan or an Event, etc'), 'classname' => 'widget_promos'),
			array( )
		);
	}

	public function form( $instance )
	{
		$template = $field = array( );
		$title = apply_filters('widget_title', empty($instance['title_en']) ? '' : $instance['title_en'], $instance);
		$instance = wp_parse_args((array) $instance, array('image_en'=>'', 'link_en' =>'','image_fr'=>'', 'link_fr' =>''));
		foreach($this->langs as $lang):
			$field[$lang]["image"]["id"]    = $this->get_field_id('image_'.$lang);
			$field[$lang]["image"]["name"]  = $this->get_field_name('image_'.$lang);
			$field[$lang]["image"]["value"] = strip_tags($instance['image_'.$lang]);
			$field[$lang]["link"]["id"]     = $this->get_field_id('link_'.$lang);
			$field[$lang]["link"]["name"]   = $this->get_field_name('link_'.$lang);
			$field[$lang]["link"]["value"]  = strip_tags($instance['link_'.$lang]);
		endforeach;
		$template["langs"] = $this->langs;
		$template["field"] = $field;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.promos.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['image_'.$lang] = strip_tags($n['image_'.$lang]);
			$i['link_'.$lang] = strip_tags($n['link_'.$lang]);
		endforeach;
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		$template["before_widget"] = $before_widget;
		$template["image"]         = @q8_translate($instance['image_en'],$instance['image_fr']);
		$template["link"]          = @q8_translate($instance['link_en'],$instance['link_fr']);
		$template["after_widget"]  = $after_widget;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.promos.twig.html',$template);
		}
	}
}

class MPWP_VideoPlayer extends MPWP_Widget 
{
	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'videoplayer',
			__('Video Player'),
			array( 'description' => __('Embed one of your YouTube videos'), 'classname' => 'widget_videoplayer'),
			array( )
		);
	}
	
	public function form( $instance )
	{
		global $wpdb;
		$template = $field = array( );
		$instance = wp_parse_args((array) $instance, array('title_en'=>'', 'youtube_url_en'=>'', 'video_link_en' =>'', 'video_image_en' =>'','title_fr'=>'', 'youtube_url_fr'=>'', 'video_link_fr' =>'', 'video_image_fr' =>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]          = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]        = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"]       = strip_tags($instance['title_'.$lang]);
			$field[$lang]["youtube_url"]["id"]    = $this->get_field_id('youtube_url_'.$lang);
			$field[$lang]["youtube_url"]["name"]  = $this->get_field_name('youtube_url_'.$lang);
			$field[$lang]["youtube_url"]["value"] = strip_tags($instance['youtube_url_'.$lang]);
			$field[$lang]["video_link"]["id"]     = $this->get_field_id('video_link_'.$lang);
			$field[$lang]["video_link"]["name"]   = $this->get_field_name('video_link_'.$lang);
			$field[$lang]["video_link"]["value"]  = strip_tags($instance['video_link_'.$lang]);
			$field[$lang]["video_image"]["id"]    = $this->get_field_id('video_image_'.$lang);
			$field[$lang]["video_image"]["name"]  = $this->get_field_name('video_image_'.$lang);
			$field[$lang]["video_image"]["value"] = strip_tags($instance['video_image_'.$lang]);
		endforeach;
		$vids = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'video/mp4' ORDER BY post_name ASC;");
		foreach ($vids as $vid):
			foreach($this->langs as $lang):
				$selected = ($field[$lang]["video_link"]["value"] == $vid->ID) ? 'selected="selected"' : NULL;
				$field[$lang]["video_options"] .= '<option value="'.$vid->ID.'" '.$selected.' >'.$vid->post_title.'</option>';
			endforeach;
		endforeach;
		$imgs = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'image/jpeg' ORDER BY post_name ASC;");
		foreach ($imgs as $img):
			foreach($this->langs as $lang):
				$selected = ($field[$lang]["video_image"]["value"] == $vid->ID) ? 'selected="selected"' : NULL;
				$field[$lang]["image_options"] .= '<option value="'.$img->ID.'" '.$selected.' >'.$img->post_title.'</option>';
			endforeach;
		endforeach;
		$template["langs"] = $this->langs;
		$template["field"] = $field;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.videoplayer.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
			$i['youtube_url_'.$lang] = strip_tags($n['youtube_url_'.$lang]);
			$i['video_link_'.$lang] = strip_tags($n['video_link_'.$lang]);
			$i['video_image_'.$lang] = strip_tags($n['video_image_'.$lang]);
			$i['youtube_id_'.$lang] = q8_get_youtube_id( $i['youtube_url_'.$lang] );
		endforeach;
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		$youtube_id = @q8_translate($instance['youtube_id_en'],$instance['youtube_id_fr']);
		$video_link = @q8_translate($instance['video_link_en'],$instance['video_link_fr']);
		$video_image = @q8_translate($instance['video_image_en'],$instance['video_image_fr']);
		if ($video_link && (0 != $video_link)) {
			$template["vid"] = get_post($video_link);
			$template["video"] = $template["vid"]->guid;
			$template["image"] = '';
			$template["provider"] = 'video';
			if ($video_image) {
				$template["img"] = get_post($video_image);
				$template["image"] = $template["img"]->guid;
			}
		}
		if ($youtube_id) {
			$template["video"] = 'http://www.youtube.com/watch?v='.$youtube_id;
			$template["image"] = 'http://img.youtube.com/vi/'.$youtube_id.'/0.jpg';
			$template["provider"] = 'youtube';
		}

		$template["before_widget"]      = $before_widget;
		$template["before_title"]       = $before_title;
		$template["title"]              = apply_filters('widget_title', @q8_translate(empty($instance['title_en']),empty($instance['title_fr'])) ? '' : @q8_translate($instance['title_en'],$instance['title_fr']), $instance);
		$template["after_title"]        = $after_title;
		$template["after_widget"]       = $after_widget;
		$template["widget_id"]          = $args["widget_id"];
		$template["MPWEB_TEMPLATE_DIR"] = MPWEB_TEMPLATE_DIR;
		$template["ASSET_URL"]          = ASSET_URL;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.videoplayer.twig.html',$template);
		}
	}
}

class MPWP_RecentPosts extends MPWP_Widget 
{
	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'recentposts',
			__('Recent POSTs'),
			array( 'description' => __('Display my recent POSTs based on category'), 'classname' => 'widget_recentposts'),
			array( )
		);
	}
	
	public function form( $instance )
	{
		global $wpdb;
		$template = $field = array( );
		$instance = wp_parse_args((array) $instance, array('title_en'=>'','title_fr'=>'','quantity' =>'', 'categories' =>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]          = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]        = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"]       = strip_tags($instance['title_'.$lang]);
		endforeach;
		$field["quantity"]["id"]    = $this->get_field_id('quantity');
		$field["quantity"]["name"]  = $this->get_field_name('quantity');
		$field["quantity"]["value"] = format_to_edit($instance['quantity']);

		$categories = $instance['categories'];
		$categories = split(",",$categories);
		$args = array( 'orderby' => 'name', 'order' => 'ASC' );
		$cats = get_categories( $args );
		$x=0;
		foreach ($cats as $cat):
			$x++;
			$checked = (in_array((int)$cat->term_id,$categories)) ? 'checked="checked"' : NULL ;
			$options .= '<li><label for="cpc_categories_'.$x.'"><input type="checkbox" name="'.$this->get_field_name('categories').'[]" id="cpc_categories_'.$x.'" value="'.$cat->term_id.'" '.$checked.' />&nbsp;' . $cat->name . '</label></li>';
		endforeach;
		$template["langs"]   = $this->langs;
		$template["field"]   = $field;
		$template["options"] = $options;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.recentposts.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
		endforeach;
		$i['quantity'] = $n['quantity'];
		foreach ($n['categories'] as $cats): $cpc_custom_categories .= $cats . ","; endforeach;
		$cpc_custom_categories = substr($cpc_custom_categories,0,-1);
		$i['categories'] = $cpc_custom_categories;
		return $i;
	}

	public function widget( $args, $instance )
	{
		extract($args);
		$template = array( );
		$quantity = (!$instance['quantity']) ? 5 : $instance['quantity'];
		$categories = (!$instance['categories']) ? 1 : $instance['categories'];
		$args = array("cat" => $categories, "posts_per_page" => $quantity, "orderby" => "date", "order" => "DESC");
		$query = new WP_Query($args);
		if ( $query->have_posts() ) : 
			$template["posts"] = array( );
			$x = 0;
			while ($query->have_posts()) :
				$query->the_post();
				$template["posts"][$x]["link"] = get_permalink();
				$template["posts"][$x]["title"] = get_the_title();
				$x++;
			endwhile; 
		endif; wp_reset_postdata();
		$template["before_widget"] = $before_widget;
		$template["before_title"]  = $before_title;
		$template["title"]         = apply_filters('widget_title', @q8_translate(empty($instance['title_en']),empty($instance['title_fr'])) ? '' : @q8_translate($instance['title_en'],$instance['title_fr']), $instance);
		$template["after_title"]   = $after_title;
		$template["after_widget"]  = $after_widget;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.recentposts.twig.html',$template);
		}

	}
}

class MPWP_Events extends MPWP_Widget
{
	public function __construct(  ) 
	{
		parent::__construct( );
		WP_Widget::__construct(
			'events',
			__('Upcoming Events'),
			array( 'description' => __('Display my upcoming events'), 'classname' => 'widget_events'),
			array( )
		);
	}

	private function cmp( $a, $b ) 
	{ 
		if ( $a['event_date'] > $b['event_date'] )
		{
			return true;
		}
		return false;
	}
	
	public function form( $instance )
	{
		global $wpdb;
		$template = $field = array( );
		$instance = wp_parse_args((array) $instance, array('title_en'=>'','title_fr'=>'','quantity' =>'','notice_en'=>'','notice_fr'=>''));
		foreach($this->langs as $lang):
			$field[$lang]["title"]["id"]          = $this->get_field_id('title_'.$lang);
			$field[$lang]["title"]["name"]        = $this->get_field_name('title_'.$lang);
			$field[$lang]["title"]["value"]       = strip_tags($instance['title_'.$lang]);
			$field[$lang]["notice"]["id"]          = $this->get_field_id('notice_'.$lang);
			$field[$lang]["notice"]["name"]        = $this->get_field_name('notice_'.$lang);
			$field[$lang]["notice"]["value"]       = strip_tags($instance['notice_'.$lang]);
		endforeach;
		$field["quantity"]["id"]    = $this->get_field_id('quantity');
		$field["quantity"]["name"]  = $this->get_field_name('quantity');
		$field["quantity"]["value"] = format_to_edit($instance['quantity']);
		$template["langs"]          = $this->langs;
		$template["field"]          = $field;
		$template['bilingual'] 		= ( @q8_french_enabled( ) ) ? true : false;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.events.twig.html',$template);
	}
	
	public function update( $n, $o )
	{
		$i = $o;
		foreach($this->langs as $lang):
			$i['title_'.$lang] = strip_tags($n['title_'.$lang]);
			$i['notice_'.$lang] = strip_tags($n['notice_'.$lang]);
		endforeach;
		$i['quantity'] = $n['quantity'];
		return $i;
	}

	public function widget( $args, $instance )
	{
		global $MPWP, $post;
		extract( $args );
		$template = array( );
		$quantity = ( !$instance['quantity'] ) ? 3 : $instance['quantity'];
		$the_location = @q8_translate( 'location_en', 'location_fr' );
		$event_name = @q8_translate( 'cpc_event_name_en', 'cpc_event_name_fr' );
		$the_cpc_location = @q8_translate('cpc_event_location_en','cpc_event_location_fr');
		$today = date( 'Y-m-d H:i:s' );
		$args = array(
			'category_name'	=> @$MPWP->categories['events'],
			'posts_per_page'	=> $quantity,
			'orderby'		=> 'meta_value',
			'meta_key'		=> 'cpc_event_date',
			'order'			=> 'ASC',
			'meta_query'		=> array( 
				array(
					'key'		=> 'cpc_event_date', 
					'value'		=> $today,
					'type'		=> 'CHAR',
					'compare'	=> '>='
				)
			)
		);
		$query = new WP_Query( $args );
		if ( $query->have_posts( ) ) : 
			$x = ( -1 ); 
			while ( $query->have_posts( ) ) : 
				$query->the_post( );
				$x++;
				$name = get_post_meta( $query->post->ID, $event_name, true );
				$template["events"][$x]["title"]    = ( $name ) ? $name : get_the_title( );
				$location = get_post_meta( $query->post->ID, $the_cpc_location, true );
				$template["events"][$x][$the_location] = ( $location ) ? $location : NULL;
				$template["events"][$x]["map"]      = get_post_meta( $query->post->ID, $the_cpc_location, true );
				$template["events"][$x]["location_map"]	= get_post_meta( $query->post->ID, 'cpc_event_location_map', true );
				$template["events"][$x]["location_map_embed"]	= get_post_meta( $query->post->ID, 'cpc_event_location_map_embed', true );
				$template["events"][$x]["date"]     = strtotime( get_post_meta( $query->post->ID, 'cpc_event_date', true ) );
				//$template["events"][$x]["time"]     = get_post_meta( $query->post->ID, 'cpc_event_time', true );
				
				$event_time	= get_post_meta( $query->post->ID, 'cpc_event_time', true );
				$event_time = ( 0 == ( int )substr( $event_time, 0, 1 ) ) ? substr( $event_time, 1 ) : $event_time;
				$template["events"][$x]["time"] = $event_time;
				
				$template["events"][$x]["link"]     = get_permalink( );
			endwhile; 
		endif;
		wp_reset_postdata( );
		$template["before_widget"] = $before_widget;
		$template["before_title"]  = $before_title;
		$template["title"]         = apply_filters('widget_title', @q8_translate( empty( $instance['title_en'] ), empty( $instance['title_fr'] ) ) ? '' : @q8_translate($instance['title_en'], $instance['title_fr'] ), $instance);
		$template["after_title"]   = $after_title;
		$template["after_widget"]  = $after_widget;
		$template["notice"]        = @q8_translate($instance['notice_en'],$instance['notice_fr']);
		$template["location_text"] = q8_translate('Location', 'location');
		if( defined( "CHILD_TEMPLATE_DIR_TEMPLATES" ) && defined( "CHILD_THEME_PREFIX" ) )
		{
			$twig = q8_new_twig_engine( CHILD_TEMPLATE_DIR_TEMPLATES );
			echo $twig->render( CHILD_THEME_PREFIX.'.widget.events.twig.html', $template );
		}
	}
}

function register_all_widgets() {
	register_widget('Code_Widget');
	register_widget('MPWP_SocialNetworks');
	register_widget('MPWP_RecentNews');
	register_widget('MPWP_RecentPosts');
	register_widget('MPWP_Events');
	register_widget('MPWP_Promos');
	register_widget('MPWP_VideoPlayer');
}

add_action('widgets_init', 'register_all_widgets');

?>