<?php 
if (!function_exists('add_action')) { header('Status: 403 Forbidden'); header('HTTP/1.1 403 Forbidden'); exit("403 Error!"); }
define('MPWEB_HOME', get_option('home'));
define('MPWEB_TEMPLATE_DIR', get_bloginfo('template_directory'));
define("MPWEB_TEMPLATE_DIR_TEMPLATES", dirname(__FILE__).'/templates');
define('MPWEB_TEMPLATE_DIR_SCRIPTS', MPWEB_TEMPLATE_DIR.'/scripts');
define('MPWEB_TEMPLATE_DIR_IMAGES', MPWEB_TEMPLATE_DIR.'/images');
define('ASSET_URL', '//assets.cpccaucus.ca/');
define('RIDING_ID', get_option( 'cpc_riding_id' ) );

if( !class_exists( 'MPWP' ) ):
class MPWP
{
	/**
	 *	Common Vars
	 */
	var $langs									= array( );
	var $theme_mpwp_version						= "mpwp_version";
	var $sys_msg                               	= NULL;
	var $pomona_access                         	= NULL;
	var $theme_mp_banner                       	= 'cpc_mp_banner';
	var $theme_mp_banner_extras               	= 'cpc_mp_banner_extras';
	var $theme_mp_bannerbg                     	= 'cpc_mp_bannerbg';
	var $theme_mp_footer_menu                  	= 'cpc_mp_footer_menu';
	var $theme_mp_contact_form                 	= 'cpc_mp_contact_form';
	var $theme_mp_contact_form_notification    	= 'cpc_mp_contact_form_notification';
	var $theme_mp_map_settings                 	= "cpc_mp_map_settings";
	var $theme_mp_map_offices                 	= "cpc_mp_map_offices";
	var $theme_mp_contact_info                 	= "cpc_mp_contact_info";
	var $theme_mp_email_signup_form_db_version 	= 'cpc_mp_email_signup_form_db_version';
	var $theme_mp_email_signup_form            	= 'cpc_mp_email_signup_form';
	var $theme_mp_email_form_notification      	= 'cpc_mp_email_form_notification';
	var $theme_mp_feature_slider               	= 'cpc_mp_feature_slider';
	var $theme_mp_social_tools                 	= 'cpc_mp_social_tools';
	var $theme_mp_getting_started              	= 'cpc_mp_getting_started';
	var $theme_mp_googleanalytics              	= 'cpc_mp_googleanalytics';
	var $theme_mp_general_config               	= 'cpc_mp_general_config';
	var $theme_mp_hot_topics                   	= 'cpc_mp_hot_topics';
	var $theme_mp_photo_gallery_config         	= 'cpc_mp_photo_gallery_config';
	var $theme_mp_splash_page_settings         	= 'cpc_mp_splash_page_settings';
	var $theme_mp_splash_page                  	= 'cpc_mp_splash_page';
	var $theme_mp_splash_page_theme_settings   	= 'cpc_mp_splash_page_theme_settings';
	var $categories                            	= array(
		'cta'				=> 'cta',
		'events'			=> 'events',
		'feature-article'	=> 'feature-article',
		'feature-video'		=> 'feature-video',
		'media-release'		=> 'media-release',
		'news-riding'		=> 'news-riding',
		'news-government'	=> 'news-government',
		'op-ed'				=> 'op-ed',
		'press-release'		=> 'press-release',
		'speeches'			=> 'speeches',
		'subfeature'		=> 'subfeature',
		'homepage'			=> 'homepage'
	);

	public function __construct(  ) 
	{
		if ( defined( "Q8_CORE_ACTIVE_FLAG" ) )
			$this->langs = (q8_french_enabled()) ? array('en','fr') : array('en');
	}
	
	/**
	 *	Common Helpers
	 */

	/**
	 *	@function	main_excerpt
	 *	@params 	<content:string> contains the content
	 *	@return 	string - <content:string> having been run through <func:str_replace> to replace "..." with "[...]"
	 */
	public function main_excerpt($content) { $content = str_replace( array( "[...]", "[&hellip;]" ), "...", $content); return $content; }

	/**
	 *	@function	downloads
	 *	@params 	void
	 *	@return 	void
	 */
	public function downloads( )
	{
		if (isset($_POST["contact_form_download"])) { @$this->contact_form_extraction(); exit(); }
		if (isset($_POST["email_signup_form_download"])) { @$this->email_signup_form_extraction(); exit(); }
	}

	/**
	 *	@function	contact_form_extraction
	 *	@params 	void
	 *	@return 	void
	 */	
	public function contact_form_extraction( ) 
	{
		global $wpdb;
		$setting = get_option(@$this->theme_mp_contact_form);
		$wpdb->cpc_contact = $wpdb->prefix.'cpc_contact';
		$users = $wpdb->get_results("SELECT * FROM $wpdb->cpc_contact ORDER BY id ASC;");
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=MP_Contact_Form.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		echo '<?xml version="1.0"?>';
		?>
	<ss:Workbook xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
	<ss:Styles>
	<ss:Style ss:ID="1">
	    <ss:Font ss:Bold="1" ss:Size="12" ss:Color="#1F497D"/>
	    <ss:Interior ss:Color="#C5D9F1" ss:Pattern="Solid"/>
	</ss:Style>
	</ss:Styles>
	<ss:Worksheet ss:Name="Contacts">
	<ss:Table>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="600"/>
	<ss:Column ss:Width="100"/>
	<ss:Row>
	<ss:Cell><ss:Data ss:Type="String">NAME</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">EMAIL</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">POSTALCODE</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">PHONENUMBER</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">MESSAGE</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">DATE</ss:Data></ss:Cell>
	</ss:Row>
	<?php 
	foreach ($users as $user):
	$message = str_replace(chr(10),"&#10;",$user->message);
	?>
	<ss:Row>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->name;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->email;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->postalcode;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->phonenumber;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $message;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo date("F j, Y", strtotime($user->timestamp));?></ss:Data></ss:Cell>
	</ss:Row>
	<?php endforeach; ?>
	</ss:Table>
	</ss:Worksheet>
	</ss:Workbook>
	<?php
	}
	/**
	 *	@function	email_signup_form_extraction
	 *	@params 	void
	 *	@return 	void
	 */	
	public function email_signup_form_extraction( )
	{
		global $wpdb;
		$wpdb->cpc_email_signup = $wpdb->prefix.'cpc_email_signup';
		$users = $wpdb->get_results("SELECT * FROM $wpdb->cpc_email_signup ORDER BY id ASC;");
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=MP_Email_Signup_Form.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
		echo '<?xml version="1.0"?>';
		?>
	<ss:Workbook xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet">
	<ss:Styles>
	<ss:Style ss:ID="1">
	    <ss:Font ss:Bold="1" ss:Size="12" ss:Color="#1F497D"/>
	    <ss:Interior ss:Color="#C5D9F1" ss:Pattern="Solid"/>
	</ss:Style>
	</ss:Styles>
	<ss:Worksheet ss:Name="Signups">
	<ss:Table>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="100"/>
	<ss:Column ss:Width="50"/>
	<ss:Column ss:Width="50"/>
	<ss:Row>
	<ss:Cell><ss:Data ss:Type="String">NAME</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">EMAIL</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">POSTALCODE</ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String">DATE</ss:Data></ss:Cell>
	</ss:Row>
	<?php foreach($users as $user):
	?>
	<ss:Row>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->name;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->email;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo $user->postalcode;?></ss:Data></ss:Cell>
	<ss:Cell><ss:Data ss:Type="String"><?php echo date("F j, Y", strtotime($user->timestamp));?></ss:Data></ss:Cell>
	</ss:Row>
	<?php endforeach; ?>
	</ss:Table>
	</ss:Worksheet>
	</ss:Workbook>
	<?php
	}

	/**
	 *	@function	search_widget
	 *	@params 	<args:string>
	 *				<instance:string>
	 *	@return 	void
	 */	
	public function search_widget($args, $instance) {
		extract($args);
		$template                  = array( );
		$template["s"]             = trim($_REQUEST["s"]);
		$o                         = get_option('cpc_search_widget_options');
		$template["langurl"]       = (@q8_french_enabled()) ? '<input type="hidden" name="lang" value="'.$_REQUEST["lang"].'">' : NULL;
		$template["before_widget"] = $before_widget;
		$template["before_title"]  = $before_title;
		$template["title"]         = $o["cpc_search_widget_title_en"];
		$template["after_title"]   = $after_title;
		$template["blurb"]         = $o["cpc_search_widget_blurb_en"];
		$template["MPWEB_HOME"]    = MPWEB_HOME;
		$template["btn_text"]      = @q8_translate("Search","Searchez");
		$template["after_widget"]  = $after_widget;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.search.twig.html',$template);
		}
	}

	/**
	 *	@function	search_widget_controls
	 *	@params 	void
	 *	@return 	void
	 */	
	public function search_widget_controls( )
	{
		$template = array( );
		$template["hidden_field_name"] = 'cpc_search_widget_form';
		if (isset($_POST[$template["hidden_field_name"]])) {
	        update_option(
	        	'cpc_search_widget_options', 
	        	array(
	        		"cpc_search_widget_title_en" => @q8_clean_post($_POST['cpc_search_widget_title_en']),
	        		"cpc_search_widget_blurb_en" => @q8_clean_post($_POST['cpc_search_widget_blurb_en'])
	        		)
	        	);
	    }
	    $template["options"] = get_option('cpc_search_widget_options');
	    $twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
	    echo $twig->render('mpwp.widgetform.search.twig.html',$template);
	}

	/**
	 *	@function	modify_footer_admin
	 *	@params 	void
	 *	@return 	void
	 */	
	public function modify_footer_admin () { echo 'Created by <a href="http://www.c-source.ca" target="_blank">CRG Web Team</a>.'; }

	/**
	 *	@function	remove_menu_items
	 *	@params 	void
	 *	@return 	void
	 */	
	public function remove_menu_items( )
	{
		global $menu;
		$current_user = wp_get_current_user();
		$restricted = array(__('Links'), __('Comments'), __('Tools'));
		if ("crgweb@parl.gc.ca"!=$current_user->user_email) { $restricted = array(__('Links'), __('Comments'), __('Tools')); }
		if (("crgweb@parl.gc.ca"!=$current_user->user_email) || (1!=$current_user->ID)) { __('Plugins'); }
		end ($menu);
		while (prev($menu)){
			$value = explode(' ',$menu[key($menu)][0]);
			if(in_array($value[0] != NULL?$value[0]:"" , $restricted)) { unset($menu[key($menu)]); }
		}
	}

	/**
	 *	@function	remove_submenus
	 *	@params 	void
	 *	@return 	void
	 */	
	public function remove_submenus() { global $submenu; unset($submenu['index.php'][10]); /*Removes 'Updates'*/ unset($submenu['edit.php'][16]); /*Removes 'Tags'*/ }

	/**
	 *	@function	delete_submenu_items
	 *	@params 	void
	 *	@return 	void
	 */	
	//public function delete_submenu_items() {remove_submenu_page('themes.php', 'theme-editor.php');remove_submenu_page('plugins.php', 'plugin-editor.php');}

	/**
	 *	@function	reconfigure_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function reconfigure_dashboard( )
	{
		global $wp_meta_boxes;
		$setting = get_option(@$this->theme_mp_getting_started);
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_recent_comments']);
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_activity']);
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_plugins']);
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_primary']);
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_secondary']);
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_incoming_links']);
		unset($wp_meta_boxes['dashboard']['normal']['core']['dashboard_right_now']);
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_quick_press']);
		unset($wp_meta_boxes['dashboard']['side']['core']['dashboard_recent_drafts']);

		$pomona_request = wp_remote_get( "http:".ASSET_URL."access" );

		if ( $pomona_request["response"]["code"] === 403 )
			$this->pomona_access = $pomona_request["body"];

		if ( !empty( $this->pomona_access ) )
		{
			add_meta_box('mpweb_dashboard_pomona_access', __("NO ACCESS"), array(&$this, 'mpweb_dashboard_pomona_access'), 'dashboard', 'normal', 'high');
		}


		$sys_msg = wp_remote_get( "http:".ASSET_URL.'sys_msg' );
		$decoded = NULL;
		if ( ! $sys_msg instanceof WP_Error )
			$decoded = json_decode( $sys_msg["body"] );
		if ( !empty( $decoded ) && ( is_object( $decoded ) || is_array( $decoded ) ) )
		{
			$this->sys_msg = $decoded;

			$sys_msg_exists = false;
			foreach( $this->sys_msg as $index => $sys_msg )
			{
				$action_already = get_option( "mpwp_update_".$sys_msg->id );
				if ( FALSE === ( $action_already ) )
					$sys_msg_exists = true;
				else
					unset( $this->sys_msg[$index] );
			}

			if ( $sys_msg_exists && (bool)$setting["website_setup"] )
				add_meta_box('mpweb_dashboard_sys_msg', __("CRG Message"), array(&$this, 'mpweb_dashboard_sys_msg'), 'dashboard', 'side', 'high');
		}

		if ( $pomona_request["response"]["code"] !== 403 )
			if (1 != (int)$setting["website_setup"]) { wp_add_dashboard_widget('mpweb_dashboard_2', __("Getting Started"), array(&$this, 'mpweb_dashboard_2')); }

		if (1 == (int)$setting["website_setup"]) { wp_add_dashboard_widget('mpweb_dashboard_1', __("MP Website Program"), array(&$this, 'mpweb_dashboard_1')); }

		add_meta_box('mpweb_dashboard_3', __("CRG Web Services"), array(&$this, 'mpweb_dashboard_3'), 'dashboard', 'side');
	}

	public function mpweb_dashboard_pomona_access( )
	{
		?>
		<style>
		#mpweb_dashboard_pomona_access .inside { background: #FCF8E3; margin: 0; padding: 12px; }
		#mpweb_dashboard_pomona_access p { margin: 0; padding: 5px 0; }
		#mpweb_dashboard_pomona_access h4 { font-weight: bold; margin: 0 0 10px; padding: 0; }
		</style>
		<?php echo $this->pomona_access; ?>
		<?php
	}

	public function sys_admin_alert( )
	{
		global $current_screen;
		if ( !empty( $this->sys_msg ) && ( is_object( $this->sys_msg ) || is_array( $this->sys_msg ) ) )
		{
			if( "dashboard" != $current_screen->base )
			{
				?>
				<div class="update-nag" style="font-size: 1.2em;">
					<p>
						<a href="index.php"><?php echo __("There is a message from CRG available. Visit the dashboard to view it or click here to see it."); ?></a>
					</p>
				</div>
				<?php
			}
		}
	}

	/**
	 *	@function	disableAutoSave
	 *	@params 	void
	 *	@return 	void
	 */	
	public function disableAutoSave(){ wp_deregister_script('autosave'); }

	/**
	 *	@function	wp_admin_scripts
	 *	@params 	void
	 *	@return 	void
	 */	
	
	function mpwp_initialize_theme_options( )
	{
		add_settings_section( 'general_settings_section', 'Additional Site Info', array(&$this, 'mpwp_general_options_callback'), 'general' );
		add_settings_field( 'mpwp_sitename_firstname', 'MP First Name', array( &$this, 'mpwp_sitename_firstname_callback' ), 'general', 'general_settings_section', array(  'Enter the first name of the MP here' ) );
		add_settings_field( 'mpwp_sitename_lastname', 'MP Last Name', array( &$this, 'mpwp_sitename_lastname_callback' ), 'general', 'general_settings_section', array(  'Enter the last name of the MP here' ) );
		register_setting( 'general', 'mpwp_sitename_firstname' );
		register_setting( 'general', 'mpwp_sitename_lastname' );
	}
 
	function mpwp_general_options_callback( )
	{
		echo '<p>This info is exclusively for the MP Website Program template.</p>';
	}
 

	function mpwp_sitename_firstname_callback( $args )
	{
		$html = '<input type="text" id="mpwp_sitename_firstname" name="mpwp_sitename_firstname" value="' . get_option( 'mpwp_sitename_firstname' ) . '" class="regular-text" placeholder="'  . $args[0] . '" maxlength="64" />';
		echo $html;
	}
	
	function mpwp_sitename_lastname_callback( $args )
	{
		$html = '<input type="text" id="mpwp_sitename_lastname" name="mpwp_sitename_lastname" value="' . get_option( 'mpwp_sitename_lastname' ) . '" class="regular-text" placeholder="'  . $args[0] . '" maxlength="64" />'; 
		echo $html;
	}
 
	public function wp_admin_scripts( ) 
	{
		@$this->mpwp_initialize_theme_options( ); //http://code.tutsplus.com/tutorials/the-complete-guide-to-the-wordpress-settings-api-part-2-sections-fields-and-settings--wp-24619
		
		if ( is_admin( ) ) 
		{ 
			wp_enqueue_script( 'jquery' );
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-datepicker', MPWEB_TEMPLATE_DIR . '/scripts/jqueryui/jquery.ui.datepicker.js', array( 'jquery', 'jquery-ui-core' ) );
			wp_enqueue_script( 'jquery-ui-timepicker', MPWEB_TEMPLATE_DIR . '/scripts/timepicker/jquery.ui.timepicker.js', array( 'jquery', 'jquery-ui-core' ) );
			wp_enqueue_script( 'media-upload' );
			wp_enqueue_script( 'thickbox' );
			wp_enqueue_script( 'fancybox', ASSET_URL . 'fancybox/fancybox.js', array( 'jquery' ) );
		}
	}

	/**
	 *	@function	wp_admin_styles
	 *	@params 	void
	 *	@return 	void
	 */	
	public function wp_admin_styles( ) 
	{
		if ( is_admin( ) ) 
		{
			wp_enqueue_style( 'thickbox' );
			wp_enqueue_style( 'fancybox', ASSET_URL . 'fancybox/fancybox.css' );
			wp_enqueue_style( 'wp', MPWEB_TEMPLATE_DIR_SCRIPTS . '/wp.css' );
			wp_enqueue_style( 'jquery-ui-theme', MPWEB_TEMPLATE_DIR . '/scripts/jqueryui/themes/ui-lightness/jquery-ui-1.8.15.custom.css' );
			wp_enqueue_style( 'jquery-ui-timepicker', MPWEB_TEMPLATE_DIR . '/scripts/timepicker/jquery.ui.timepicker.css' );
		}
	}

	public function mpweb_dashboard_sys_msg( )
	{
		foreach($this->sys_msg as $index => $sys_msg):
			if ( !empty( $sys_msg->alert_type ) )
			{
				$query = "&id=".$sys_msg->id."&";
				foreach( $sys_msg->alert_type->scripts as $script )
				{
					$query .= "update[]=".$script;
					if ( $index !== ( count( $this->sys_msg ) - 1 ) )
						$query .= "&";
				}
			}
		?>
			<?php echo $sys_msg->msg; ?>
			<?php if ( !empty( $query ) ): ?>
			<p><a href="<?php echo admin_url( "admin.php?page=mpwp_update" ).$query; ?>" class="button button-primary"><?php echo $sys_msg->alert_type->text; ?></a></p>
			<?php endif; ?>
			<?php if ( $index !== ( count( $this->sys_msg ) - 1 ) ): ?><hr /><?php endif; ?>
		<?php
		endforeach
;	}

	/**
	 *	@function	mpweb_dashboard_1
	 *	@params 	void
	 *	@return 	void
	 */	
	public function mpweb_dashboard_1( )
	{
		global $wp_version;
		if (!version_compare($wp_version, "3.5.1", ">=")) { 
			echo '<p>'.__('This Theme template requires WordPress 3.5.1 or higher. You currently have installed WordPress ','congratulatory').$wp_version.__('. It may not be compatible, use at your own risk or download and intall the correct version by <a href="http://wordpress.org/wordpress-3.5.1.zip">clicking here.</a>').'</p>';
		}
		else {
			if (current_user_can('administrator')) { $click_here_to_edit_theme = 'To view other available themes, <strong><a href="themes.php">click here</a></strong>.'; }
			echo '<h2>General Info</h2><p>For assistance on a particular section you\'re in, click on the "<strong><a href="#help" class="trigger-show-settings">Help</a></strong>" menu at the top right hand corner.  For general website settings such as your Photo Gallery or Video Gallery <strong><a href="themes.php?page=mpwp-settings">click here</a></strong> to add or edit the contents.</p>';
			echo '<p><div style="background:url(http:'.ASSET_URL.CHILD_THEME_PREFIX.'/preview.jpg) no-repeat top center;width:100%; min-height:474px;"></div></p>';
			echo '<p>This is the <b>'.THEME_NAME.'</b>. '.$click_here_to_edit_theme.'</p>';
		}
	}

	/**
	 *	@function	cmp
	 *	@params 	<a:array>
	 *				<b:array>
	 *	@return 	bool - value of <func:strcmp> on <a[riding]:array> and <b[riding]:array>
	 */	
	public function cmp($a, $b) { return strcmp($a["riding"], $b["riding"]); }

	/**
	 *	@function	mpweb_dashboard_2
	 *	@params 	void
	 *	@return 	void
	 */	
	public function mpweb_dashboard_2( )
	{
		global $wpdb, $q_config;

		$ridings = wp_remote_get( "http:".ASSET_URL."ridings" );
		$decoded = null;
		if ( ! $ridings instanceof WP_Error )
			$decoded = json_decode( $ridings["body"] );
		if ( !is_null( $decoded ) && is_array( $decoded ) || is_object( $decoded ) )
			$ridings = $decoded;

		$template = array( );
		$template["hidden_field_name3"] = "website_setup";

		if ( isset( $_POST[$template["hidden_field_name3"]] ) )
		{
			$cpc_riding_id = trim( $_POST["cpc_riding_id"] );
			if ( 0 != $cpc_riding_id ) 
			{
				update_option( "cpc_riding_id", $cpc_riding_id );
				update_option( "blogdescription", $ridings->{$cpc_riding_id}->name );
				update_option( "blogname", $ridings->{$cpc_riding_id}->member );

				$version = get_option( @$this->theme_mpwp_version );
				if ( FALSE === $version )
				{
					$version = wp_remote_get( "http:".ASSET_URL."version" );
					update_option( $this->theme_mpwp_version, json_decode( $version["body"] ) );
				}
				
				if ( !empty( $q_config ) )
					$install_scripts = wp_remote_get( "http:".ASSET_URL."install/bil" );
				else
					$install_scripts = wp_remote_get( "http:".ASSET_URL."install" );

				if ( ! $install_scripts instanceof WP_Error )
					$install_scripts = base64_decode( $install_scripts["body"] );
				else
					$install_scripts = null;

				if ( !is_null( $install_scripts ) )
				{
					require_once ABSPATH."wp-admin/includes/upgrade.php";
					require_once ABSPATH."wp-admin/includes/image.php";
					ob_start( );
					$status = eval( "?>".$install_scripts );
					$return = ob_get_clean( );
				
					if ( is_null( $status ) )
					{
						update_option( @$this->theme_mp_getting_started, array( "website_setup" => "1" ) );
						$template["msg"] = '<div class="alert alert-success"><p>'.__('Your default settings were successfully installed. You can now begin using your website!').' <a href="themes.php?page=mpwp-settings">'.__('Click here to edit settings for this theme.').'</a></p></div>';
					}
					
					if ( FALSE === $status )
					{
						var_dump( $install_scripts );
						$template["msg"] = '<div class="alert alert-success"><p>'.__('There was an error setting up your website, please contact CRG Caucus Services.').'</p><p>Error: '.$return.'</div>';
					}
				}
			}
			else {
				$template["msg"] = '<div class="alert alert-success"><p>'.__('You must choose your riding to continue!').'</p></div>';
			}
		}

		$template["theme_name"] = THEME_NAME;

		foreach ($ridings as $rid => $r_info)
			$template["options"] .= '<option value="'.trim($rid).'">'.$r_info->name.' - '.$r_info->member.'</option>'.chr(13);

		$template["setting"] = get_option(@$this->theme_mp_getting_started);
		if ( ( 1 == (int)$template["setting"]["website_setup"] ) && isset( $_POST[$template["hidden_field_name3"]] ) ) 
		{
			$twig = q8_new_twig_engine( MPWEB_TEMPLATE_DIR_TEMPLATES );
			echo $twig->render( "mpwp.dashboard.complete.twig.html", $template );
		}
		else
		{
			$twig = q8_new_twig_engine( MPWEB_TEMPLATE_DIR_TEMPLATES );
			echo $twig->render( "mpwp.dashboard.setup.twig.html", $template );
		}
	}

	/**
	 *	@function	mpwp_update
	 *	@params 	void
	 *	@return 	void
	 */	
	public function mpwp_update( )
	{
		$id = $_GET["id"];
		$scripts = $_GET["update"];

		$query = "?";
		foreach( $scripts as $index => $script )
		{
			$query .= "script[]=".$script;
			if ( $index !== ( count( $scripts ) - 1 ) )
				$query .= "&";
		}

		$install_scripts = wp_remote_get( "http:".ASSET_URL."update".$query );
		if ( ! $install_scripts instanceof WP_Error )
			$install_scripts = base64_decode( $install_scripts["body"] );
		else
			$install_scripts = null;

		if ( !is_null( $install_scripts ) )
		{
			ob_start( );
			$return = eval( "?>".$install_scripts );
			$scrub = ob_get_clean( );

			if ( empty( $return ) && empty( $scrub ) )
			{
				echo "<div style=\"text-align:center; margin-top:50px;\"><h1>UPDATE WAS SUCCESSFUL</h1></div>";
				update_option( "mpwp_update_".$id, true );
			}
			else
				echo "<div style=\"margin-top:50px;\"><p>{$return}</p><p>{$scrub}</p></div>";
		}
	}

	/**
	 *	@function	mpweb_dashboard_3
	 *	@params 	void
	 *	@return 	void
	 */	
	public function mpweb_dashboard_3( )
	{
		$template = array( );
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.dashboard.faq.twig.html',$template);
	}
	/**
	 *	@function	admin_menu
	 *	@params 	void
	 *	@return 	void
	 */	
	public function admin_menu( )
	{
		@$this->add_posts_page_panels();
		@$this->remove_submenus();
		@$this->remove_menu_items();
		@$this->theme_settings();
		@$this->theme_save_posts();
	}

	/**
	 *	@function	theme_save_posts
	 *	@params 	void
	 *	@return 	void
	 */	
	public function theme_save_posts( ) 
	{
		add_action('save_post', array(&$this,'menu_save_postdata'));
		add_action('save_post', array(&$this,'footer_save_postdata'));
		add_action('save_post', array(&$this,'feature_save_postdata'));
		add_action('save_post', array(&$this,'subfeature_save_postdata'));
		add_action('save_post', array(&$this,'media_save_postdata'));
		add_action('save_post', array(&$this,'event_save_postdata'));
		add_action('save_post', array(&$this,'custom_categories_save_postdata'));
		add_action('save_post', array(&$this,'template_save_postdata'));
		add_action('save_post', array(&$this,'metatags_save_postdata'));
	}
	/**
	 *	@function	theme_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function theme_settings( )
	{
		wp_enqueue_script('common'); wp_enqueue_script('wp-lists'); wp_enqueue_script('postbox');
		$setting = get_option(@$this->theme_mp_getting_started);
		if (1 == (int)$setting["website_setup"]) {
			add_theme_page(__(THEME_NAME.' Settings'), __(THEME_NAME.' Settings'), 'edit_pages', 'mpwp-settings', array(&$this, 'theme_settings_dashboard'));
			add_theme_page(__('Contact Form Settings'), __('Contact Form Settings'), 'edit_pages', 'mpwp-settings-2', array(&$this, 'contact_form_settings_dashboard'));
			add_theme_page(__('Email Signup Form Settings'), __('Email Signup Form Settings'), 'edit_pages', 'mpwp-settings-3', array(&$this, 'email_signup_settings_dashboard'));
			add_theme_page(__('Video Gallery'), __('Video Gallery'), 'edit_pages', 'mpwp-settings-4', array(&$this, 'video_gallery_settings_dashboard'));
			add_theme_page(__('Photo Gallery'), __('Photo Gallery'), 'edit_pages', 'mpwp-settings-5', array(&$this, 'photo_gallery_settings_dashboard'));
			add_theme_page(__('Splash Page'), __('Splash Page'), 'edit_pages', 'mpwp-settings-7', array(&$this, 'splash_page_settings'));
			add_submenu_page('themes.php', 'Customize Your Sidebar', 'Customize Your Sidebar', 7, 'widgets.php');
		}
	}
	/**
	 *	@function	theme_settings_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function theme_settings_dashboard( )
	{
		$current_user = wp_get_current_user();
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			if ( 'crgweb@parl.gc.ca'==$current_user->user_email ) {
				$block->add_tab('panel_banner_bg_extras',__('Riding Backdrop Extras'),array(&$this,'panel_banner_bg_extras'));
			}
			$block->add_tab('panel_banner_bg',__('Riding Backdrop'),array(&$this,'panel_banner_bg'));
			$block->add_tab('panel_feature_slider_setting',__('Feature Slider'),array(&$this,'panel_feature_slider_setting'));
			$block->add_tab('panel_subpage_image_setting',__('Subpage Default Image'),array(&$this,'panel_subpage_image_setting'));
			if( in_array( CHILD_THEME_PREFIX, array( 'congratulatory', 'mandatory' ) ) )
			{
				$block->add_tab('panel_hot_topics_setting',__('Hot Topics'),array(&$this,'panel_hot_topics_setting'));
			}
			$block->add_tab('panel_socialsharingtools_setting',__('Social Sharing'),array(&$this,'panel_socialsharingtools_setting'));
			if( 'victory' == CHILD_THEME_PREFIX )
			{
				$block->add_tab('panel_footer_menu',__('Footer Menu'),array(&$this,'panel_footer_menu'));
			}
			$block->draw_block(THEME_NAME.' Settings','','Theme settings below will be reflected in the appropriate areas on your site.');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}

	/**
	 *	@function	panel_banner_bg_extras
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_banner_bg_extras( )
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "banner_bg_extras";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$banner_bg_extras = @q8_clean_post($_POST["banner_bg_extras"]);
			$fields = array('banner_bg_extras'=>$banner_bg_extras);
			update_option(@$this->theme_mp_banner_extras, $fields);
			$template["msg"] = '<div class="alert alert-success"><p>'.__('Your banner settings are successfully updated.').'</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_banner_extras);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.bgextras.twig.html',$template);
	}

	/**
	 *	@function	panel_banner_bg
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_banner_bg( )
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "update_your_banner_backdrop";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$banner_backdrop = trim($_POST["banner_backdrop"]);
			if ($banner_backdrop) {
				update_option(@$this->theme_mp_bannerbg, array('banner_backdrop'=>$banner_backdrop));
				$template["msg"] = '<div class="alert alert-success"><p>'.__('You have successfully updated your backdrop!').'</p></div>';
			}
			else { $template["msg"] = '<div class="alert alert-error"><p>'.__('Error, an image must be selected before updating!').'</p></div>'; }
		}
		$template["setting"] = get_option(@$this->theme_mp_bannerbg); 
		$template["CHILD_TEMPLATE_DIR_IMAGES"] = CHILD_TEMPLATE_DIR_IMAGES;
		$template["ASSET_URL"] = ASSET_URL.CHILD_THEME_PREFIX;
		$setting2 = get_option(@$this->theme_mp_banner_extras);
		$template["banner_bg_extras"] = explode(",",$setting2["banner_bg_extras"]);
		
		if ( 'mandatory' == CHILD_THEME_PREFIX )
		{
			$template['parl_theme_1'] = 'header_banner_parl_1.jpg';
			$template['parl_theme_2'] = 'header_banner_parl_2.jpg';
			$template['parl_theme_3'] = 'header_banner_parl_3.jpg';
		}
		else
		{
			$template['parl_theme_1'] = 'header_banner_parl_1.png';
			$template['parl_theme_2'] = 'header_banner_parl_2.png';
			$template['parl_theme_3'] = 'header_banner_parl_3.png';
		}
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.banner_bg.twig.html',$template);
	}
	/**
	 *	@function	panel_feature_slider_setting
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_feature_slider_setting( )
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "feature_slider_setting";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$delay = trim($_POST["delay"]);
			update_option(@$this->theme_mp_feature_slider, array('delay'=>$delay));
			$template["msg"] = '<div class="alert alert-success"><p>'.__('Your Feature Slider settings has been updated.').'</p></div>';
		}
		$setting = get_option(@$this->theme_mp_feature_slider);
		for ($x=5;$x<=60;$x=$x+5) {
			$selected = ((int)$setting["delay"] == $x) ? ' selected="selected"' : NULL;
			$template["options"] .= '<option value="'.$x.'"'.$selected.'>'.$x.' Seconds</option>';
		}
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.feature_slider.twig.html',$template);
	}
	/**
	 *	@function	panel_subpage_image_setting
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_subpage_image_setting( )
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "subpage_image_setting";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$subpage_image = ($_POST["subpage_image"]) ? 1 : 0;
			$wmvideo_gallery_db = trim($_POST["wmvideo_gallery_db"]);
			$message = ($_POST["subpage_image"]) ? __("Default graphics of Feature/Subfeature articles are now enabled on subpages") : __("Default graphics of Feature/Subfeature articles are now disabled (hidden) on subpages");
			update_option(@$this->theme_mp_general_config, array('subpage_image'=>$subpage_image,'wmvideo_gallery_db'=>$wmvideo_gallery_db));
			$template["msg"] = '<div class="alert alert-success"><p>'.$message.'</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_general_config);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.subpage_image.twig.html',$template);
	}

	public function panel_socialsharingtools_setting( ) 
	{
		$template = array( );
		$template["msg"] = NULL;
		$template["hidden_field_name"] = "socialsharingtools_setting";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$socnettoolvisible = ($_POST["socnettoolvisible"]) ? 1 : 0;
			$message = ($_POST["socnettoolvisible"]) ? "Your Social Network sharing tools is now visible" : "Your Social Network sharing tools is now disabled (hidden)";
			$fields = array('socnettoolvisible'=>"$socnettoolvisible");
			update_option(@$this->theme_mp_social_tools, $fields);
			$template["msg"] = '<div class="alert alert-success"><p>'.$message.'</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_social_tools);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.socialsharing.twig.html',$template);
	}

	public function panel_footer_menu( )
	{
		$template = array( );
		$template["msg"] = NULL;
		$template["hidden_field_name"] = "enable_disable_footer_menu";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$footer_menu = ($_POST["footer_menu"]) ? 1 : 0;
			$message = ($_POST["footer_menu"]) ? "Your Footer Menu is now visible" : "Your Footer Menu is now disabled (hidden)";
			$fields = array('footer_menu'=>$footer_menu);
			update_option(@$this->theme_mp_footer_menu, $fields);
			$template["msg"] = '<div class="alert alert-success"><p>'.$message.'</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_footer_menu);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.footermenu.twig.html',$template);
	}
	/**
	 *	@function	contact_form_settings_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function contact_form_settings_dashboard( )
	{
		$current_user = wp_get_current_user();
		$setting = get_option(@$this->theme_mp_contact_form);
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			$block->add_tab('panel_contact_form_settings',__('General Settings'),array(&$this,'panel_contact_form_settings'));
			$block->add_tab('panel_contact_form_notification',__('Notification Settings'),array(&$this,'panel_contact_form_notification'));
			$block->add_tab('panel_contact_form_download',__('Form Download'),array(&$this,'panel_contact_form_download'));
			$block->add_tab('panel_contact_map_settings',__('Riding Map Settings'),array(&$this,'panel_contact_map_settings'));
			$block->draw_block('Contact Settings','V. 1.1','These settings are reflected on the contact page.');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}

	/**
	 *	@function	panel_contact_form_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_contact_form_settings( )
	{
		global $wpdb;
		$msg = NULL;
		$template = array( );
		$valid_form = true;
		$template["hidden_field_name"] = "contact_form_settings";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$setting1 = get_option(@$this->theme_mp_contact_form);
			$tbl_version = trim($_POST["tbl_version"]);		
			foreach($this->langs as $lang):
				$name_text        = @q8_clean_post($_POST["name_text_".$lang]);
				$email_text       = @q8_clean_post($_POST["email_text_".$lang]);
				$postalcode_text  = @q8_clean_post($_POST["postalcode_text_".$lang]);
				$phonenumber_text = @q8_clean_post($_POST["phonenumber_text_".$lang]);
				$message_text     = @q8_clean_post($_POST["message_text_".$lang]);
				$subject_text     = @q8_clean_post($_POST["subject_text_".$lang]); //Added Dec 18 ,2017
				$st_address_text     = @q8_clean_post($_POST["st_address_text_".$lang]);  //Added Dec 18 ,2017
				$city_town     = @q8_clean_post($_POST["city_town_".$lang]); //Added Jan 26, 2018
				$province     = @q8_clean_post($_POST["province_".$lang]);  //Added Jan 26, 2018
				$error_message    = @q8_clean_post($_POST["error_message_".$lang]); 
				$success_message  = @q8_clean_post($_POST["success_message_".$lang]);
				$valid_form       = ($name_text) ? $valid_form : false;
				$valid_form       = ($email_text) ? $valid_form : false;
				$valid_form       = ($postalcode_text) ? $valid_form : false;
				$valid_form       = ($phonenumber_text) ? $valid_form : false;
				$valid_form       = ($message_text) ? $valid_form : false;
				$valid_form       = ($error_message) ? $valid_form : false;
				$valid_form       = ($success_message) ? $valid_form : false;
				if($valid_form):
					$fields['name_text_'.$lang]        = $name_text;
					$fields['email_text_'.$lang]       = $email_text;
					$fields['postalcode_text_'.$lang]  = $postalcode_text;
					$fields['phonenumber_text_'.$lang] = $phonenumber_text;
					$fields['message_text_'.$lang]     = $message_text;
					$fields['error_message_'.$lang]    = $error_message;
					$fields['success_message_'.$lang]  = $success_message;
				endif;
			endforeach;
			if($valid_form):
				$fields['tbl_version'] = $tbl_version;
				update_option(@$this->theme_mp_contact_form, $fields);
				$template["msg"] = '<div class="alert alert-success"><p>'.__('Your Contact Form Settings have been updated!').'</p></div>';
			else:
				$template["msg"] = '<div class="alert alert-error"><p>'.__('Please ensure all the fields are entered.').'</p></div>';
			endif;
		}
		$template["setting"] = get_option(@$this->theme_mp_contact_form);
		$template["french_enabled"] = q8_french_enabled();
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.contactform_settings.twig.html',$template);
	}
	/**
	 *	@function	panel_contact_form_notification
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_contact_form_notification( )
	{
		global $wpdb;
		$template = array( );
		$msg = NULL;
		$template["hidden_field_name"] = "contact_form_notifcation";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$to_notify_name = @q8_clean_post($_POST["to_notify_name"]);
			$to_notify_email = @q8_clean_post($_POST["to_notify_email"]);
			$notify = ($_POST["notify"]) ? 1 : 0;
			$valid_emails = @q8_verify_email_addresses($to_notify_email);
			if ($to_notify_name && $to_notify_email) {
				$a = explode(",",$to_notify_name);
				$b = explode(",",$to_notify_email);
				$valid_name_email = (count($a) == count($b)) ? true : false;
			}
			if ($to_notify_name && $to_notify_email && $valid_name_email && $valid_emails){
				update_option(@$this->theme_mp_contact_form_notification, array('to_notify_name'=>$to_notify_name,'to_notify_email'=>$to_notify_email,'notify'=>$notify));
				$template["msg"] = '<div class="alert alert-success"><p>'.__('Your Contact Form Notification Settings have been updated!').'</p></div>';
			}
			else {
				$template["msg"] = '<div class="alert alert-error"><p>'.__('Please ensure fields are entered correctly.').'</p></div>';
			}
		}
		$template["setting"] = get_option(@$this->theme_mp_contact_form_notification);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.contactform_notifications.twig.html',$template);
	}

	/**
	 *	@function	panel_contact_form_download
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_contact_form_download( )
	{
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.contactform_download.twig.html',array());
	}

	/**
	 *	@function	panel_contact_map_settings
	 *	@params 	void
	 *	@return 	void
	 */
	public function panel_contact_map_settings( )
	{

		if ( isset( $_POST["type"] ) )
		{
			if ( "map" === $_POST["type"] )
			{
				$map = get_option( $this->theme_mp_map_settings );
				$map["map_type"] = $_POST["map_type"];
				$map["google_maps_id"] = $_POST["google_maps_id"];
				$map["pin_style"] = $map["pin_styles"][$_POST["pin_style"]];
				update_option( $this->theme_mp_map_settings, $map );
				unset( $map );
			}

			if ( "member" === $_POST["type"] )
			{
				$member = get_option( $this->theme_mp_contact_info );
				$member->hillphone = $_POST["hillphone"];
				$member->hillfax = $_POST["hillfax"];
				$member->email = $_POST["email"];
				update_option( $this->theme_mp_contact_info, $member );
				unset( $member );
			}

			if ( "office" === $_POST["type"] )
			{
				$office = array( );
				foreach( $_POST["office"] as $index => $new_office )
				{
					$details = wp_remote_get( "http://maps.googleapis.com/maps/api/geocode/json?address=".urlencode( $new_office["address"].", ".$new_office["city"].", ".$new_office["province"].", ".$new_office["postalcode"] )."&sensor=false" );
					$details = json_decode( $details["body"] );
					$location = $details->results[0]->geometry->location;

					$temp = new stdClass( );
					$temp->suite = $new_office["suite"];
					$temp->address = $new_office["address"];
					$temp->city = $new_office["city"];
					$temp->province = $new_office["province"];
					$temp->postalcode = $new_office["postalcode"];
					$temp->phone = $new_office["phone"];
					$temp->fax = $new_office["fax"];
					$temp->location = $location;
					$office[] = $temp;
				}
				update_option( $this->theme_mp_map_offices, $office );
				unset( $office );
			}
		}

		/**
		 *	Getting Settings for Output
		 */
		$settings["map"] = get_option( $this->theme_mp_map_settings );
		$settings["member"] = get_option( $this->theme_mp_contact_info );
		$settings["offices"] = get_option( $this->theme_mp_map_offices );

		$twig = q8_new_twig_engine( MPWEB_TEMPLATE_DIR_TEMPLATES );
		echo $twig->render( "mpwp.panel.contactform_mapsettings.twig.html", $settings );
	}

	/**
	 *	@function	email_signup_settings_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function email_signup_settings_dashboard( )
	{ 
		$current_user = wp_get_current_user();
		$setting = get_option(@$this->theme_mp_email_signup_form_db_version);
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			$block->add_tab('panel_email_signup_form_settings',__('General Settings'),array(&$this,'panel_email_signup_form_settings'));
			$block->add_tab('panel_email_signup_form_notification',__('Notification Settings'),array(&$this,'panel_email_signup_form_notification'));
			$block->add_tab('panel_email_signup_form_download',__('Form Download'),array(&$this,'panel_email_signup_form_download'));
			$block->draw_block('Email Signup Form Settings','V. 1.3','These settings are reflected in the email sign up widget.');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}

	/**
	 *	@function	panel_email_signup_form_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_email_signup_form_settings( )
	{
		global $wpdb;
		$template = array( );
		$msg = NULL;
		$french_enabled = @q8_french_enabled();
		$template["hidden_field_name"] = "email_signup_form_settings";
		if (isset($_POST[$template["hidden_field_name"]])) {
			//$fields['email_signup'] = trim($_POST["email_signup"]);
			foreach($this->langs as $lang):
				$caption         = @q8_clean_post($_POST["caption_".$lang]);
				$name_text       = @q8_clean_post($_POST["name_text_".$lang]);
				$email_text      = @q8_clean_post($_POST["email_text_".$lang]);
				$postalcode_text = @q8_clean_post($_POST["postalcode_text_".$lang]);
				$submit_text     = @q8_clean_post($_POST["submit_text_".$lang]);
				$error_message   = @q8_clean_post($_POST["error_message_".$lang]);
				$success_message = @q8_clean_post($_POST["success_message_".$lang]);
				$validform       = ($caption && $name_text && $email_text && $postalcode_text && $submit_text && $error_message && $success_message) ? true : false;
				if($validform):
					$fields['caption_'.$lang]         = $caption;
					$fields['name_text_'.$lang]       = $name_text;
					$fields['email_text_'.$lang]      = $email_text;
					$fields['postalcode_text_'.$lang] = $postalcode_text;
					$fields['submit_text_'.$lang]     = $submit_text;
					$fields['error_message_'.$lang]   = $error_message;
					$fields['success_message_'.$lang] = $success_message;
				endif;
			endforeach;			
			if ($validform):
				update_option(@$this->theme_mp_email_signup_form, $fields);
				$template["msg"] = '<div class="alert alert-success"><p>'.__('Your Email Signup Form Settings have been updated!').'</p></div>';
			else:
				$template["msg"] = '<div class="alert alert-error"><p>'.__('Please ensure all the fields are entered.').'</p></div>';
			endif;
		}
		$template["setting"] = get_option(@$this->theme_mp_email_signup_form);
		$template["french_enabled"] = @q8_french_enabled();
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.emailsignup_settings.twig.html',$template);
	}
	/**
	 *	@function	panel_email_signup_form_notification
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_email_signup_form_notification( )
	{
		global $wpdb;
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "email_signup_form_notifcation";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$to_notify_name = @q8_clean_post($_POST["to_notify_name"]);
			$to_notify_email = @q8_clean_post($_POST["to_notify_email"]);
			$notify = ($_POST["notify"]) ? 1 : 0;
			$valid_emails = @q8_verify_email_addresses($to_notify_email);
			if ($to_notify_name && $to_notify_email) {
				$a = explode(",",$to_notify_name);
				$b = explode(",",$to_notify_email);
				$valid_name_email = (count($a) == count($b)) ? true : false;
			}
			if ($to_notify_name && $to_notify_email && $valid_name_email && $valid_emails){
				$fields = array('to_notify_name'=>$to_notify_name,'to_notify_email'=>$to_notify_email,'notify'=>$notify);
				update_option(@$this->theme_mp_email_form_notification, $fields);
				$template["msg"] = '<div class="alert alert-success"><p>'.__('Your Email Signup Form Notification Settings have been updated!').'</p></div>';
			}
			else {
				$template["msg"] = '<div class="alert alert-error"><p>'.__('Please ensure fields are entered correctly.').'</p></div>';
			}
		}
		$template["setting"] = get_option(@$this->theme_mp_email_form_notification);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.emailsignup_notifications.twig.html',$template);
	}
	/**
	 *	@function	panel_email_signup_form_download
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_email_signup_form_download( )
	{
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.emailsignup_download.twig.html',array());
	}
	/**
	 *	@function	video_gallery_settings_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function video_gallery_settings_dashboard() {
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			$block->add_tab('panel_video_playlist_add_video',__('Add a Video'),array(&$this,'panel_video_playlist_add_video'));
			$block->add_tab('panel_video_playlist_list_videos',__('My Videos'),array(&$this,'panel_video_playlist_list_videos'));
			$block->draw_block('Video Gallery','V. 1.1','Setup your video gallery here.');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}
	/**
	 *	@function	panel_video_playlist_add_video
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_video_playlist_add_video( )
	{
		global $wpdb,$current_user;
		$msg = NULL;
		$template = array( );
		$date = date("Y-m-d");
		$video_visible = 1;
		$valid_video = false;
		$template["hidden_field_name"] = "video_playlist_add_video";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$date = @q8_clean_post($_POST["video_date"]);
			$valid_date = preg_match('/^[0-9]{4}[-][0-9]{2}[-][0-9]{2}$/', $date);
			$caption_en = ($_POST["video_caption_en"]);
			$caption_fr = (@q8_french_enabled()) ? @q8_clean_post($_POST["video_caption_fr"]) : $caption_en;
			$youtube = @q8_clean_post($_POST["video_youtube"]);
			$video_visible = ($_POST["video_visible"]) ? 1 : 0;
			$video_id = $_POST["video_id"];
			$video_image_id = $_POST["video_image_id"];
			if ( $youtube )
			{
				$v = q8_get_youtube_id( $youtube );				
				$valid_video = false;
				if ( !empty( $v ) && $v !== $youtube )
				{
					$youtube_id = $v;
					$valid_video = true;
				}
			}
			else {
				$youtube_id = NULL;
			}
			$valid_video = ($video_id) ? true : $valid_video;
			if ($valid_date && $caption_en && $caption_fr && $valid_video){
				$current_user = wp_get_current_user();
				$cid = (is_numeric($current_user->ID)) ? $current_user->ID : 1;
				$wpdb->cpc_video_gallery = $wpdb->prefix.'cpc_video_gallery';

				$new_video = $wpdb->insert(
					$wpdb->cpc_video_gallery,
					array(
						'video_date'       => $date,
						'video_caption_en' => $caption_en,
						'video_caption_fr' => $caption_fr,
						'video_youtube_id' => $youtube_id,
						'video_id'         => $video_id,
						'video_image_id'   => $video_image_id,
						'visible'          => $video_visible,
						'user_id'          => $cid
					),
					array( '%s', '%s', '%s', '%s', '%d', '%d', '%d', '%d' )
				);
				
				if ( $new_video )
				{
					$template["msg"] = '<div class="alert alert-success"><p>Your video was successfully added!</p></div>';
					$date = date("Y-m-d");
					$caption_en = $caption_fr = $youtube = $video_id = $video_image_id = NULL;
					$video_visible = 1;
				}
				else {
					$template["msg"] = '<div class="alert alert-error"><p>Please ensure all the fields are entered and entered correctly in the proper format.</p></div>';
				}
			}
			else {
				$template["msg"] = '<div class="alert alert-error"><p>Please ensure all the fields are entered and entered correctly in the proper format.</p></div>';
			}
			
		}
		
		$template["caption_en"] = $caption_en;
		$template["caption_fr"] = $caption_fr;
		$template["date"] = $date;
		$template["youtube"] = $youtube;
		
		$vids = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'video/mp4' ORDER BY post_name ASC;");
		$template["vid_options"] = '<option value="0">Select your video</option>'. chr(13);
		foreach ($vids as $vid) {
			$selected = ($video_id == $vid->ID) ? 'selected="selected"' : NULL;
			$template["vid_options"] .= '<option value="'.$vid->ID.'" '.$selected.' >'.$vid->post_title.'</option>'.chr(13);
		}
		
		$imgs = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'image/jpeg' ORDER BY post_name ASC;");
		$template["img_options"] = '<option value="0">Select your video image</option>'. chr(13);
		foreach ($imgs as $img) {
			$selected = ($video_image_id == $img->ID) ? 'selected="selected"' : NULL;
			$template["img_options"] .= '<option value="'.$img->ID.'" '.$selected.' >'.$img->post_title.'</option>'.chr(13);
		}
		$template["french_enabled"] = @q8_french_enabled();
		$template["video_visible"] = $video_visible;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.videogallery_add.twig.html',$template);
	}
	/**
	 *	@function	panel_video_playlist_list_videos
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_video_playlist_list_videos( )
	{
		global $wpdb,$current_user;
		$template = array( );
		$wpdb->cpc_video_gallery = $wpdb->prefix.'cpc_video_gallery';
		$msg = NULL;
		$template["hidden_field_name"] = "video_playlist_list_videos";
		if(isset($_POST[$template["hidden_field_name"]])) {
			$id = trim($_POST["id"]);
			
			if ("DELETE" == $_POST["edit"]) {
				$update_video = $wpdb->query("DELETE FROM $wpdb->cpc_video_gallery WHERE id = $id;");
				$template["msg"] = '<div class="alert alert-success"><p>Your video is now removed!</p></div>';
			}
			if ("UPDATE" == $_POST["edit"]) {
				$date = @q8_clean_post($_POST["video_date"]);
				$valid_date = preg_match('/^[0-9]{4}[-][0-9]{2}[-][0-9]{2}$/', $date);
				$video_feature = ($_POST["video_feature"]) ? 1 : 0;
				$video_visible = ($_POST["video_visible"]) ? 1 : 0;
				$caption_en = @q8_clean_post($_POST["video_caption_en"]);
				$caption_fr = (@q8_french_enabled()) ? @q8_clean_post($_POST["video_caption_fr"]) : $caption_en;
				$youtube_url = @q8_clean_post($_POST["video_youtube_id"]);
				$video_id = ($_POST["video_id"]) ? ($_POST["video_id"]) : 0;
				$video_image_id = ($_POST["video_image_id"]) ? ($_POST["video_image_id"]) : 0;
				$video_youtube_id = q8_get_youtube_id( $youtube_url );
				
				if ($valid_date && $caption_en && $caption_fr){
					$current_user = wp_get_current_user();
					$cid = (is_numeric($current_user->ID)) ? $current_user->ID : 1;
					if (1 == $video_feature) {
						$update_video = $wpdb->update(
							$wpdb->cpc_video_gallery,
							array(
								'video_feature' => 0
							),
							array( )
						);
					}
					$update_video = $wpdb->update(
						$wpdb->cpc_video_gallery,
						array(
							'video_date'       => $date,
							'video_caption_en' => $caption_en,
							'video_caption_fr' => $caption_fr,
							'video_youtube_id' => $video_youtube_id,
							'video_id'         => $video_id,
							'video_image_id'   => $video_image_id,
							'video_feature'    => $video_feature,
							'visible'          => $video_visible,
							'user_id'          => $user_id
						),
						array( 'id' => $id ),
						array( '%s', '%s', '%s', '%s', '%d', '%d', '%d', '%d', '%d' ),
						array( '%d' )
					);
					
					$template["msg"] = '<div class="alert alert-success"><p>Your video was successfully updated!</p></div>';
				}
				else {
					$template["msg"] = '<div class="alert alert-error"><p>Please ensure all the fields are entered.</p></div>';
				}
			}
			
		}
		$template["french_enabled"] = @q8_french_enabled();
		$template["videoplayer_videos"] = $wpdb->get_results("SELECT * FROM $wpdb->cpc_video_gallery ORDER BY video_date DESC;");
		$imgs = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'image/jpeg' ORDER BY post_name ASC;");
		$vids = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'video/mp4' ORDER BY post_name ASC;");
		$images = array( );
		$x = 0;
		foreach( $template["videoplayer_videos"] as $video ):
			$images[$x] = wp_get_attachment_image($videoplayer_video->video_image_id,array(190,190));
			$x++;
		endforeach;
		foreach ($imgs as $img):
            $selected = ($template["videoplayer_videos"]->video_image_id == $img->ID) ? 'selected="selected"' : NULL;
            $template["img_options"] .= '<option value="'.$img->ID.'" '.$selected.' >'.$img->post_title.'</option>'.chr(13);
        endforeach;
        foreach ($vids as $vid) :
            $selected = ($$template["videoplayer_video"]->video_id == $vid->ID) ? 'selected="selected"' : NULL;
            $template["vid_options"] .= '<option value="'.$vid->ID.'" '.$selected.' >'.$vid->post_title.'</option>'.chr(13);
        endforeach;
        $twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
        echo $twig->render('mpwp.panel.videogallery_list.twig.html',$template);
	}
	/**
	 *	@function	photo_gallery_settings_dashboard
	 *	@params 	void
	 *	@return 	void
	 */	
	public function photo_gallery_settings_dashboard( ) 
	{ 
		if( class_exists( 'Q8_BLOCK' ) ):
			$block = new Q8_BLOCK( );
			$block->add_tab( 'panel_photo_gallery_setting' ,__( 'General Settings' ), array( &$this, 'panel_photo_gallery_setting' ) );
			$block->add_tab( 'panel_add_photo_gallery', __( 'Add A Photo Gallery' ), array( &$this, 'panel_add_photo_gallery' ) );
			$block->add_tab( 'panel_list_photo_galleries' ,__( 'Your Current Photo Galleries' ), array( &$this, 'panel_list_photo_galleries' ) );
			if ( isset( $_REQUEST["g_id"] ) )
			{
				$block->add_tab( 'panel_edit_photo_gallery',__( 'Edit Your Photo Gallery' ), array( &$this, 'panel_edit_photo_gallery' ) );
			}
			$block->draw_block( 'Photo Gallery','V. 1.1','Setup your photo gallery here.' );
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}

	/**
	 *	@function	photo_title_shortened
	 *	@params 	void
	 *	@return 	void
	 */	
	public function photo_title_shortened($title) { if (strlen($title) > 50) { $title = substr($title,0,50)." ..."; } return $title; }

	/**
	 *	@function	panel_photo_gallery_setting
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_photo_gallery_setting( )
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "photo_gallery_setting";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$image_size = trim($_POST["image_size"]);
			update_option(@$this->theme_mp_photo_gallery_config, array('image_size'=>$image_size));
			$template["msg"] = '<div class="alert alert-success"><p>Your settings were updated.</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_photo_gallery_config);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.photogallery_settings.twig.html',$template);
	}
	/**
	 *	@function	panel_add_photo_gallery
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_add_photo_gallery( )
	{
		global $wpdb,$current_user;
		$template = array( );
		$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
		$wpdb->cpc_photo_gallery_id = $wpdb->prefix . 'cpc_photo_gallery_id';
		$template["hidden_field_name"] = "photo_gallery_add";		
		$msg                    = NULL;
		$gallery_date           = NULL;
		$gallery_name_en        = NULL;
		$gallery_description_en = NULL;
		$gallery_name_fr        = NULL;
		$gallery_description_fr = NULL;
		$gallery_date           = date("Y-m-d");
		$gallery_visible        = 1;
		$images                 = array();
		
		if (isset($_POST[$template["hidden_field_name"]])) {
			$gallery_name_en        = @q8_clean_post($_POST["photo_gallery_name_en"]);
			$gallery_description_en = @q8_clean_post($_POST["photo_gallery_description_en"]);
			$gallery_name_fr        = @q8_clean_post($_POST["photo_gallery_name_fr"]);
			$gallery_description_fr = @q8_clean_post($_POST["photo_gallery_description_fr"]);
			$images                 = $_POST["photo_gallery_image_id"];
			$gallery_date           = trim($_POST["photo_gallery_date"]);
			$gallery_visible        = ($_POST["photo_gallery_visible"]) ? 1 : 0;
			if (empty($gallery_date)) {
				$gallery_date = date("Y-m-d");
			}
			$valid_date = preg_match('/([0-9]{4})-([0-9]{2})-([0-9]{2})/', $gallery_date);
			if ($gallery_name_en && $images && $valid_date) {
				$b = addslashes($gallery_name_en);
				$search = $wpdb->get_row("SELECT * FROM $wpdb->cpc_photo_gallery_id WHERE gallery_name_en = '$b'");
				$a = ($search) ? addslashes($search->gallery_name_en) : NULL;
				if ($b !== $a) {
					/** ********/
					$d = 0;
					foreach ($images as $c) {
						$d++;
						if ($d == 1) {
							$gallery_thumbnail = $c;
						}
					}

					get_currentuserinfo();
					$user_id = $current_user->ID;
					$data = $wpdb->insert(
						$wpdb->cpc_photo_gallery_id,
						array(
							'gallery_name_en'        => $gallery_name_en,
							'gallery_description_en' => $gallery_description_en,
							'gallery_name_fr'        => $gallery_name_fr,
							'gallery_description_fr' => $gallery_description_fr,
							'gallery_date'           => $gallery_date,
							'gallery_thumbnail'      => $gallery_thumbnail,
							'user_id'                => $user_id,
							'visible'                => $gallery_visible
						),
						array( '%s', '%s','%s', '%s', '%s','%d', '%d', '%d' )
					);

					$gallery_id = (int)$wpdb->insert_id;
					
					foreach ($images as $image_id) {
						$data = $wpdb->insert(
							$wpdb->cpc_photo_gallery,
							array(
								'gallery_id' => $gallery_id,
								'image_id'   => (int)$image_id
							),
							array( '%d', '%d' )
						);
					}
					$template["msg"] = '<div class="alert alert-success"><p><b>'.strtoupper($gallery_name_en).'</b> Gallery Created!&nbsp;&nbsp;<i><a href="?page=mpwp-settings-5&g_id='.$gallery_id.'#panel_edit_photo_gallery">Click here to edit</a></p></div>';
					$gallery_name_en        = NULL;
					$gallery_description_en = NULL;
					$gallery_name_fr        = NULL;
					$gallery_description_fr = NULL;
					$gallery_date           = date("Y-m-d");
					$gallery_visible        = 1;
					$images                 = array();
				}
				else {
					$template["msg"] = '<div class="alert alert-error"><p>The gallery <b>Name</b> you chose already exists!</p></div>';
				}
			}
			else {
				$template["msg"] = '<div class="alert alert-error"><p>You must create a <b>Name</b> and select at least one image.  <b>Date</b> is not required but must be in proper format if added!</p></div>';
			}
		}
		
		$template["gallery_name_en"]        = $gallery_name_en;
		$template["gallery_description_en"] = $gallery_description_en;
		$template["gallery_name_fr"]        = $gallery_name_fr;
		$template["gallery_description_fr"] = $gallery_description_fr;
		$template["gallery_date"]           = $gallery_date;
		$template["gallery_visible"]        = $gallery_visible;

		$photos = $wpdb->get_results( "SELECT * FROM `$wpdb->posts` WHERE `post_type` = 'attachment' AND `post_mime_type` LIKE 'image%';" );
		$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
		$photos_used = $wpdb->get_results( "SELECT `image_id` FROM `$wpdb->cpc_photo_gallery`;" );
		$used = array();
		foreach( $photos_used as $photo_used ):
			$used[] = $photo_used->image_id;
		endforeach;

		$options = array( );
		$j = 0;
		$photo_count = (count($photos)-count($used)-50); //Added to show only latest 50 images and placehold.it the rest 
		foreach( $photos as $photo ):
			if ( !in_array( $photo->ID, $used ) )
			{
				$options[$j]["checked"]   = (in_array($photo->ID, ( array )$images)) ? 'checked="checked"' : NULL;
				$options[$j]["title"]     = $this->photo_title_shortened( $photo->post_title );
				$options[$j]["id"]        = $photo->ID;
				$options[$j]["thumbnail"] = ( $j > $photo_count ) ? wp_get_attachment_image( $photo->ID, 'thumbnail' ) : '<img width="100" height="100" src="http://placehold.it/100x100" class="attachment-100x100" alt="1">';
				$options[$j]["guid"]      = $photo->guid;
				$j++;
			}
		endforeach;
		$template["options"] = $options;
		$template["photos"] = $photos;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.photogallery_add.twig.html',$template);
	}
	/**
	 *	@function	panel_list_photo_galleries
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_list_photo_galleries( )
	{
		global $wpdb;
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "remove_gallery";
		$wpdb->cpc_photo_gallery_id = $wpdb->prefix . 'cpc_photo_gallery_id';
		if (isset($_POST[$template["hidden_field_name"]])) {
			$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
			$gallery_name_en = @q8_clean_post($_POST["gallery_name_en"]);
			$gallery_id = trim($_POST["gallery_id"]);
			$delete_data = $wpdb->query("DELETE FROM $wpdb->cpc_photo_gallery_id WHERE id = ".$gallery_id.";");
			$delete_data2 = $wpdb->query("DELETE FROM $wpdb->cpc_photo_gallery WHERE gallery_id = ".$gallery_id.";");
			$template["msg"] = '<div class="alert alert-success"><p>You have removed the <b>' .$gallery_name_en. '</b>  photo gallery!</p></div>';
		}
		
		$r = $wpdb->get_results( "SELECT * FROM $wpdb->cpc_photo_gallery_id ORDER BY gallery_date DESC;" );
		$total_records = $template["total_records"] = $wpdb->num_rows;
		
		$how_many_records_to_display = 10;
		
		if ( isset( $_REQUEST["pg"] ) )
		{
			$from_num = ( $_REQUEST["pg"] * $how_many_records_to_display ) - $how_many_records_to_display;
			$to_num = $how_many_records_to_display;//( $_REQUEST["pg"] * $how_many_records_to_display );
		}
		else {
			$from_num = 0;
			$to_num = $how_many_records_to_display;
		}
		
		$pages = ceil($total_records / $how_many_records_to_display);
		
		for ( $i = 1; $i <= $pages; $i++ )
		{
			$j = ( $_REQUEST["pg"] == $i ) ? 'style="color:#000033; font-weight:bold; font-size:14px;"' : 'style="text-decoration:none;"' ;
			$page_links .= '<a href="themes.php?page=mpwp-settings-5&pg=' . $i . '#panel_list_photo_galleries" ' . $j . '>' . $i . '</a>&nbsp; ';
		}
		
		$template["page_links"] = ( ( 0 == $pages ) || ( 1 == $pages ) ) ? NULL : '<tr><td colspan=5">Page: ' . $page_links . '</td></tr>';
		
		$template["galleries"] = $wpdb->get_results( "SELECT * FROM $wpdb->cpc_photo_gallery_id ORDER BY gallery_date DESC LIMIT $from_num, $how_many_records_to_display" );
		$template["images"] = array( );
		$x=0;
		foreach($template["galleries"] as $gallery):
			$template["images"][$x]["thumbnail"] = wp_get_attachment_image($gallery->gallery_thumbnail,array(50,50));
			$x++;
		endforeach;
		$template["french_enabled"] = @q8_french_enabled();
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.photogallery_list.twig.html',$template);
	}
	/**
	 *	@function	panel_edit_photo_gallery
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_edit_photo_gallery( )
	{
		global $wpdb,$current_user;
		$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
		$wpdb->cpc_photo_gallery_id = $wpdb->prefix . 'cpc_photo_gallery_id';
		$template = array( );
		$template["hidden_field_name"] = "photo_gallery_edit";
		$g_id = ( int ) trim( $_REQUEST["g_id"] );		
		$template["msg"] = NULL;
		if ( isset( $_POST[$template["hidden_field_name"]] ) )
		{
			$gallery_name_en          = @q8_clean_post($_POST["photo_gallery_name_en"]);
			$gallery_description_en   = @q8_clean_post($_POST["photo_gallery_description_en"]);
			$gallery_name_fr          = @q8_clean_post($_POST["photo_gallery_name_fr"]);
			$gallery_description_fr   = @q8_clean_post($_POST["photo_gallery_description_fr"]);
			$images                   = $_POST["photo_gallery_image_id"];
			$gallery_date             = $_POST["photo_gallery_date"];
			$gallery_visible          = ($_POST["photo_gallery_visible"]) ? 1 : 0;
			$gallery_thumbnail        = $_POST["photo_gallery_thumbnail"];
			if (empty($gallery_date)) {
				$gallery_date = date("Y-m-d");
			}
			$valid_date = eregi('([0-9]{4})-([0-9]{2})-([0-9]{2})', $gallery_date);
			if ($gallery_name_en && $images && $valid_date) {
				get_currentuserinfo();
				$user_id = $current_user->ID;

				$data = $wpdb->update(
					$wpdb->cpc_photo_gallery_id,
					array(
						'gallery_name_en'        => $gallery_name_en,
						'gallery_description_en' => $gallery_description_en,
						'gallery_name_fr'        => $gallery_name_fr,
						'gallery_description_fr' => $gallery_description_fr,
						'user_id'                => $user_id,
						'gallery_date'           => $gallery_date,
						'gallery_thumbnail'      => ($gallery_thumbnail) ? $gallery_thumbnail : "",
						'visible'                => $gallery_visible,
					),
					array( 'id' => $g_id ),
					array( '%s', '%s', '%s', '%s', '%d', '%s', '%s', '%d' ),
					array( '%d' )
				);

				$data = $wpdb->delete(
					$wpdb->cpc_photo_gallery,
					array(
						'gallery_id' => $g_id
					),
					array( '%d' )
				);
				foreach ($images as $image_id):
					$data = $wpdb->insert(
						$wpdb->cpc_photo_gallery,
						array(
							'gallery_id' => $g_id,
							'image_id'   => (int)$image_id
						),
						array( '%d', '%d' )
					);
				endforeach;
				$template["msg"] = '<div class="alert alert-success"><p><b>The '.$gallery_name_en.'</b> gallery has been updated!</p></div>';
				$gallery_date = NULL;
			}
			else {
				$template["msg"] = '<div class="alert alert-error">You must create a <b>Name</b> and select at least one <b>Image</b>.  <b>Date</b> is not required, but must be a proper format if added.</div>';
			}
			
		}
		$template["g_id"] = $g_id;
		$template["gallery"] = $wpdb->get_row("SELECT * FROM $wpdb->cpc_photo_gallery_id WHERE id = $g_id");
		$template["images"] = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery WHERE gallery_id = $g_id ORDER BY id ASC");
		$photos = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type LIKE 'image%'");
		foreach ($template["images"] as $image) { 
			$selected_images[] = $image->image_id; 
		}

		$options = array();
		$j = 0;
		foreach ($photos as $photo):
			$options[$j]["checked"]   = (in_array($photo->ID, $selected_images)) ? 'checked="checked"' : NULL;
			$options[$j]["title"]     = $this->photo_title_shortened($photo->post_title);
			$options[$j]["id"]        = $photo->ID;
			$options[$j]["thumbnail"] = ( $j < 50 ) ? wp_get_attachment_image( $photo->ID, 'thumbnail' ) : '<img width="100" height="100" src="http://placehold.it/100x100" class="attachment-100x100" alt="1">';
			$options[$j]["guid"]      = $photo->guid;
			$options[$j]["radio"]     = (is_null($options[$j]["checked"])) ? "display:none;" : NULL;
			$j++;
		endforeach;
		$template["options"] = $options;

		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.photogallery_edit.twig.html',$template);
	}

	/**
	 *	@function	splash_page_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function splash_page_settings( )
	{
		$current_user = wp_get_current_user();
		$setting = get_option(@$this->theme_mp_email_signup_form_db_version);
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			// if ( 0 === strcasecmp( "crgweb@parl.gc.ca", $current_user->user_email ) )
			//	$block->add_tab('panel_splash_admin_settings',__('Admin Splash Settings'),array(&$this,'panel_splash_admin_settings'));			
			$block->add_tab('panel_splash_settings',__('Splash Page Settings'),array(&$this,'panel_splash_settings'));
			$block->add_tab('panel_splash_frontpage_settings',__('Select Front Page'),array(&$this,'panel_splash_frontpage_settings'));
			$block->add_tab('panel_splash_theme_type',__('Splash Theme'),array(&$this,'panel_splash_theme_type'));
			$block->draw_block('Splash Page','V. 1.0','Setup your splash page here.');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}

	public function add_splash_theme($x){
		$template = array( );
		$setting = get_option($this->theme_mp_splash_page_settings);
		$template["value"] = $setting["theme_options"][$x-1]["theme"];
		$template["checkedleft"] = ( "left" == $setting["theme_options"][$x-1]["theme_position"] ) ? 'checked="checked"' : NULL;
		$template["checkedright"] = ( "right" == $setting["theme_options"][$x-1]["theme_position"] ) ? 'checked="checked"' : NULL;
		$template["x"] = $x;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.partial.splash_theme.twig.html',$template);
	}
	/**
	 *	@function	panel_splash_admin_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_splash_admin_settings( )
	{
		$template = array( );
		$template["hidden_field_name"] = "mpwp_splash_admin_settings";
		$template["msg"] = NULL;
		$y=0;
		$theme_options = array();
		if (isset($_POST[$template["hidden_field_name"]])) {
			$increment = $_POST["no_of_available_themes"];
			for ($x=1;$x<=$increment;$x++) {
				$theme = @q8_clean_post($_POST["theme$x"]);
				$theme_position = trim($_POST["theme_position$x"]);
				if ($theme && $theme_position) {
					$y++;
					$theme_options[] = array('theme'=>$theme,'theme_position'=>$theme_position);
				}
			}
			update_option($this->theme_mp_splash_page_settings, array('theme_options'=>$theme_options,'no_of_available_themes'=>$y));
			$template["msg"] = '<div class="alert alert-success"><p>The theme settings are updated!</p></div>';
		}
		$setting = get_option($this->theme_mp_splash_page_settings);
		$template["no_of_available_themes"] = (is_numeric($setting["no_of_available_themes"]) && 0 !=$setting["no_of_available_themes"]) ? $setting["no_of_available_themes"] : 1;
		$template["MPWP"] = $this;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.splashpage_admin.twig.html',$template);
	}
	/**
	 *	@function	panel_splash_theme_type
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_splash_theme_type( )
	{
		$themes = wp_remote_get( "http:".ASSET_URL."splash-theme/".CHILD_THEME_PREFIX."/".RIDING_ID );
		$decoded = null;
		if ( ! $themes instanceof WP_Error )
			$decoded = json_decode( $themes["body"] );

		if ( !empty( $decoded ) && is_array( $decoded ) || is_object( $decoded ) )
			$themes = $decoded;
		else
			$themes = null;

		$template = array( );
		$template["hidden_field_name"] = "splash_theme_type";
		if ( isset( $_POST[$template["hidden_field_name"]] ) )
		{
			$fields = array( 
				"theme_slug" => q8_clean_post( $_POST["splash_theme_option"] ),
				"alignment" => q8_clean_post( $_POST["theme_alignment"] )
			);
			update_option( $this->theme_mp_splash_page_theme_settings, $fields );
			$template["msg"] = "<div class=\"alert alert-success\"><p>The Splash Theme has been updated!</p></div>";
		}
		$template["themes"] = $themes;
		$template["curr_theme"] = get_option( $this->theme_mp_splash_page_theme_settings );
		$template["ASSET_URL"] = ASSET_URL;
		$template["CHILD_THEME_PREFIX"] = CHILD_THEME_PREFIX;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.splashpage_theme.twig.html',$template);
	}
	/**
	 *	@function	panel_splash_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_splash_settings( )
	{
		global $wpdb;
		$template = array( );
		$template["hidden_field_name"] = 'splash_settings';
		$valid_video = false;
		$french_enabled = @q8_french_enabled();
		if (isset($_POST[$template["hidden_field_name"]])) {
			$splash_title_en = $splash_title_fr = @q8_clean_post($_POST['splash_title_en']);
			$splash_caption_en = $splash_caption_fr = @q8_clean_post($_POST['splash_caption_en']);
			if ($french_enabled) {
				$splash_title_fr = @q8_clean_post($_POST['splash_title_fr']);
				$splash_caption_fr = @q8_clean_post($_POST['splash_caption_fr']);
			}
			$video_youtube_en = @q8_clean_post($_POST['video_youtube_en']);
			$video_id_en = $_POST["video_id_en"];
			$video_image_id_en = $_POST["video_image_id_en"];
			if ( $video_youtube_en ) 
			{
				$youtube_id_en = q8_get_youtube_id( $video_youtube_en );
				if ( !empty( $youtube_id_en ) && $youtube_id_en !== $video_youtube_en )
					$valid_video_en = true;
			}
			else
				$youtube_id_en = NULL;
			$valid_video_en = ($video_id_en) ? true : $valid_video_en;
			$fields = array('title_en'=>$splash_title_en,'caption_en'=>$splash_caption_en,'title_fr'=>$splash_title_fr,'caption_fr'=>$splash_caption_fr,'youtube_id_en'=>$youtube_id_en,'video_id_en'=>$video_id_en,'video_image_id_en'=>$video_image_id_en);
			update_option($this->theme_mp_splash_page, $fields);
			$template["msg"] = '<div class="alert alert-success"><p>Your Splash Page Settings have been updated.</p></div>';
		}
		
		$template["settings"] = get_option($this->theme_mp_splash_page);
		
		$vids = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'video/mp4' ORDER BY post_name ASC;");
		$template["vid_options"] = '<option value="0">Select your video</option>'. chr(13);
		foreach ($vids as $vid):
			$selected = ($settings['video_id_en'] == $vid->ID) ? 'selected="selected"' : NULL;
			$template["vid_options"] .= '<option value="'.$vid->ID.'" '.$selected.' >'.$vid->post_title.'</option>'.chr(13);
		endforeach;
		
		$imgs = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_type = 'attachment' AND post_mime_type = 'image/jpeg' ORDER BY post_name ASC;");
		$template["img_options"] = '<option value="0">Select your video image</option>'. chr(13);
		foreach ($imgs as $img):
			$selected = ($settings['video_image_id_en'] == $img->ID) ? 'selected="selected"' : NULL;
			$template["img_options"] .= '<option value="'.$img->ID.'" '.$selected.' >'.$img->post_title.'</option>'.chr(13);
		endforeach;
		$template["french_enabled"] = @q8_french_enabled();
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.splashpage_settings.twig.html',$template);	
	}
	/**
	 *	@function	panel_splash_frontpage_settings
	 *	@params 	void
	 *	@return 	void
	 */	
	public function panel_splash_frontpage_settings( )
	{
		$template = array( );
		$template["hidden_field_name"] = "front_page_settings";
		if(isset($_POST[$template["hidden_field_name"]])) {
			$update_showonfront = update_option('show_on_front', trim($_POST['show_on_front']));
			$update_pageonfront = update_option('page_on_front', trim($_POST['page_on_front']));
			if($_POST['page_on_front']){
				$add_post_meta = update_post_meta($_POST['page_on_front'],'_wp_page_template','template-splash.php');
			}
			if ($update_showonfront || $update_pageonfront) {
				$template["msg"] = '<div class="alert alert-success"><p>Your Front page Settings have been updated!</p></div>';
			}
		}
		$template["option"] = get_option( 'show_on_front' );
		$template["selection"] = sprintf( __( 'Front page: %s' ), wp_dropdown_pages( array( 'name' => 'page_on_front', 'echo' => 0, 'show_option_none' => __( '&mdash; Select &mdash;' ), 'option_none_value' => '0', 'selected' => get_option( 'page_on_front' ) ) ) );
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.splashpage_frontpage.twig.html',$template);
	}
	/**
	 *	@function	add_posts_page_panels
	 *	@params 	void
	 *	@return 	void
	 */	
	public function add_posts_page_panels( )
	{
		if ( function_exists( 'add_meta_box' ) )
		{
			add_meta_box( 'cpc_feature_options' ,__( 'Feature Article Options' ), array( &$this, 'feature_inner_custom_box' ), 'post', 'normal' );
			add_meta_box( 'cpc_metatags_options', __( 'Metatag / Keyword Options' ), array( &$this, 'metatags_inner_custom_box' ), 'post' );
			add_meta_box( 'cpc_subfeature_options', __( 'Sub-Feature Article Options' ), array( &$this, 'subfeature_inner_custom_box' ), 'post', 'side' );
			add_meta_box( 'cpc_media_release_options' ,__( 'Media Release Options' ), array( &$this, 'media_inner_custom_box' ), 'post', 'side' );
			add_meta_box( 'cpc_event_options', __( 'Event Options' ), array( &$this, 'event_inner_custom_box' ), 'post', 'side' );
			add_meta_box( 'cpc_template_options', __( 'Template Options' ), array( &$this, 'template_inner_custom_box' ), 'page', 'side' );
			add_meta_box( 'cpc_menu_options', __( 'Menu Options' ), array( &$this, 'menu_inner_custom_box' ), 'page', 'side' );
			add_meta_box( 'cpc_footer_options', __( 'Footer Options' ), array( &$this, 'footer_inner_custom_box' ), 'page', 'side' );
			add_meta_box( 'cpc_custom_categories_options', __( 'Custom Categories Options' ), array( &$this, 'custom_categories_custom_box' ), 'page', 'normal', 'low' );
		}
	}
	/**
	 *	@function	metatags_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function metatags_inner_custom_box( )
	{
		global $post, $wpdb;
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["meta_keywords"] = get_post_meta($_REQUEST["post"], 'cpc_meta_keywords_'.$lang,true);
		endforeach;
		wp_nonce_field('cpc_meta_keywords_action', 'cpc_meta_keywords_noncename');
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.metatags.twig.html',$template);
	}
	/**
	 *	@function	metatags_save_postdata
	 *	@params 	void
	 *	@return 	void
	 */	
	public function metatags_save_postdata( $post_id )
	{
		if (defined('DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if (!wp_verify_nonce($_POST['cpc_meta_keywords_noncename'], 'cpc_meta_keywords_action')) return;
		if ('page' == $_POST['post_type']) { if (!current_user_can('edit_page', $post_id)) return; }
		else { if (!current_user_can('edit_post', $post_id)) return; }
		$langs = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($langs as $lang):
			@q8_save_postdata($post_id, 'cpc_meta_keywords_'.$lang, $_POST['cpc_meta_keywords_'.$lang]);
		endforeach;
		return $cpc_meta_keywords_en;
	}

	/**
	 *	@function	meta_keywords
	 *	@params 	void
	 *	@return 	void
	 */	
	public function meta_keywords( )
	{
		global $post;
		if (is_404()) return;
		if ( is_front_page( ) ) return;
		$cpc_meta_keywords = get_post_meta($post->ID, @q8_translate('cpc_meta_keywords_en','cpc_meta_keywords_fr'),true);
		$keywords = htmlspecialchars(trim($cpc_meta_keywords));
		if ($keywords) { $temp = chr(13).'<meta name="keywords" content="'.$keywords.'" />'.chr(13).chr(10); echo $temp; }
		return;
	}
	/**
	 *	@function	custom_categories_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function custom_categories_custom_box( )
	{
		$template = array( );
		$cpc_custom_categories = get_post_meta($_REQUEST["post"], 'cpc_custom_categories',true);
		global $wpdb;
		$cpc_custom_categories = split(",",$cpc_custom_categories);
		$categories = $wpdb->get_results("SELECT wterms.* FROM $wpdb->terms wterms, $wpdb->term_taxonomy wterm_taxonomy WHERE (wterms.term_id = wterm_taxonomy.term_id AND wterm_taxonomy.taxonomy = 'category') ORDER BY wterms.term_id  ASC");
		$x=$td=0;
		$options = '<tr>';
		foreach ($categories as $cat) {
			$td++; $x++;
			$checked = (in_array((int)$cat->term_id,$cpc_custom_categories)) ? 'checked="checked"' : NULL ;
			$options .= '<td><label for="cpc_custom_categories_'.$x.'"><input type="checkbox" name="cpc_custom_categories[]" id="cpc_custom_categories_'.$x.'" value="'.$cat->term_id.'" '.$checked.' />&nbsp;' . $cat->name . '</label></td>';
			if ($td >= 4) { $td=0; $options .= '</tr><tr>'; }
		}
		wp_nonce_field('cpc_custom_categories_action', 'cpc_custom_categories_noncename');
		$template["options"] = $options;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.customcategories.twig.html',$template);
	}

	/**
	 *	@function	custom_categories_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	<mydata:string>
	 */	
	public function custom_categories_save_postdata( $post_id )
	{
		if (defined('DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if (!wp_verify_nonce($_POST['cpc_custom_categories_noncename'], 'cpc_custom_categories_action')) return;
		if ('page' == $_POST['post_type']) { if ( !current_user_can('edit_page', $post_id )) return; }
		else { if ( !current_user_can('edit_post', $post_id )) return; }
		$cpc_custom_categories = NULL;
		$mydata = $_POST['cpc_custom_categories'];
		if (is_array($mydata)) {
			foreach ($_POST["cpc_custom_categories"] as $cats):
				$cpc_custom_categories .= $cats . ",";
			endforeach;
			$cpc_custom_categories = substr($cpc_custom_categories,0,-1);
		}
		@q8_save_postdata($post_id, 'cpc_custom_categories', $cpc_custom_categories);
		return $mydata;
	}
	/**
	 *	@function	menu_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function menu_inner_custom_box( )
	{
		global $wpdb;
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["menu_item_name"] = get_post_meta($_REQUEST["post"], 'cpc_menu_item_name_'.$lang,true);
		endforeach;
		$template["field"]["menu_item"] = get_post_meta($_REQUEST["post"],'cpc_menu_item',true);
		$template["field"]["menu_item_link"] = get_post_meta($_REQUEST["post"], 'cpc_menu_item_link',true);
		$subpage_item = get_post_meta($_REQUEST["post"],'cpc_subpage_item',true);
		$contact_page_id = get_option("cpc_contact_page");
		wp_nonce_field('menu_action', 'menu_noncename');
		$page_id = (isset($_REQUEST["post"])) ? $_REQUEST["post"] : 0;
		$this_is_the_parent = 0;
		if (0 <> $page_id) {
			$data = $wpdb->get_row("SELECT post_parent,menu_order FROM $wpdb->posts WHERE ID = ".$page_id.";");
			$template["field"]["menu_item_order"] = trim($data->menu_order);
			$post_parent = trim($data->post_parent);
			$data2 = $wpdb->get_row("SELECT ID FROM $wpdb->posts WHERE ID = ".$post_parent.";");
			if ($data2) {
				$this_is_the_parent = $data2->ID;
			}
		}
		$pages = $wpdb->get_results("SELECT ID, post_title, post_parent FROM $wpdb->posts WHERE (post_type = 'page' AND post_status = 'publish' AND ID <> ".$page_id.") ORDER BY ID ASC;");
		if ($pages) {
			foreach ($pages as $page):
				$page_selected = ($page->ID == $this_is_the_parent) ? 'selected="selected"' : NULL;
				$page_title = (0 == $page->post_parent) ? $page->post_title : "&nbsp;&nbsp;&nbsp;" . $page->post_title;
				$template["options_parent"] .= '<option value="'.$page->ID.'" '.$page_selected.'>'.$page_title.'</option>'.chr(13);
			endforeach;
		}
		$template["contact_page"] = ($contact_page_id === $page_id);
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.menu.twig.html',$template);
	}
	/**
	 *	@function	menu_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function menu_save_postdata( $post_id )
	{
		global $wpdb;
		if (defined('DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if (!wp_verify_nonce($_POST['menu_noncename'], 'menu_action')) return;
		if ('page' == $_POST['post_type']) { if ( !current_user_can('edit_page', $post_id )) return; }
		else { if ( !current_user_can('edit_post', $post_id )) return; }
		$cpc_menu_item = $_POST['cpc_menu_item']; @q8_save_postdata($post_id, 'cpc_menu_item', $cpc_menu_item);
		$langs = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($langs as $lang):
			@q8_save_postdata($post_id, 'cpc_menu_item_name_'.$lang, $_POST['cpc_menu_item_name_'.$lang]);
		endforeach;
		$cpc_menu_item_link = $_POST['cpc_menu_item_link']; @q8_save_postdata($post_id, 'cpc_menu_item_link', $cpc_menu_item_link);
		$cpc_parent_id = $_POST['cpc_parent_id'];
		$data = ($cpc_parent_id) ? ("none" == $cpc_parent_id) ? $wpdb->update( $wpdb->posts, array( 'post_parent' => 0 ), array( 'ID' => $post_id ), array( '%d' ),	array( '%d' ) ) :
			$wpdb->update( $wpdb->posts, array( 'post_parent' => $cpc_parent_id ), array( 'ID' => $post_id ), array( '%d' ), array( '%d' ) ) : NULL;

		$cpc_menu_item_order = $_POST["cpc_menu_item_order"];
		$data2 = ($cpc_menu_item_order && is_numeric($cpc_menu_item_order)) ? $wpdb->update( $wpdb->posts, array( 'menu_order' => $cpc_menu_item_order ), array( 'ID' => $post_id ) ) : NULL;

	}
	/**
	 *	@function	template_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function template_inner_custom_box( )
	{
		global $wpdb;
		$template = array( );
		$wp_page_template = get_post_meta($_REQUEST["post"],'_wp_page_template',true);
		wp_nonce_field('template_action', 'template_noncename');
		$templates = get_page_templates();
		foreach ($templates as $template_name=>$template_filename) :
			$template_selected = ($wp_page_template == $template_filename) ? 'selected="selected"' : NULL;
			$template["options_templates"] .= '<option value="'.$template_filename.'" '.$template_selected.'>'.$template_name.'</option>'.chr(13);
		endforeach;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.templates.twig.html',$template);
	}

	/**
	 *	@function	template_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function template_save_postdata( $post_id )
	{
		global $wpdb;
		if (defined('DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if (!wp_verify_nonce($_POST['template_noncename'], 'template_action')) return;
		if ('page' == $_POST['post_type']) { if ( !current_user_can('edit_page', $post_id )) return; }
		else { if ( !current_user_can('edit_post', $post_id )) return; }
		@q8_save_postdata($post_id, '_wp_page_template', $_POST['cpc_template']);
	}
	/**
	 *	@function	event_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function event_inner_custom_box( $object, $box )
	{
		$object_id = $object->ID;
		$template = array( );
		$template['langs'] = ( q8_french_enabled( ) )? array( 'en', 'fr' ) : array( 'en' );
		$template['bilingual'] = ( q8_french_enabled( ) )? true : false;
		foreach( $template['langs'] as $lang ):
			$template['field'][$lang]['event_name']     = get_post_meta( $object_id, 'cpc_event_name_' . $lang, true );
			$template['field'][$lang]['event_location'] = get_post_meta( $object_id, 'cpc_event_location_' . $lang, true );
		endforeach;
		$template['field']['event_date']				= get_post_meta( $object_id, 'cpc_event_date', true );
		$template['field']['event_time'] = get_post_meta( $object_id, 'cpc_event_time', true );
		$template['field']['event_location_map']		= get_post_meta( $object_id, 'cpc_event_location_map', true );
		$template['field']['event_location_map_embed']	= get_post_meta( $object_id, 'cpc_event_location_map_embed', true );
		wp_nonce_field( 'event_action', 'event_noncename' );
		$twig = q8_new_twig_engine( MPWEB_TEMPLATE_DIR_TEMPLATES );
		echo $twig->render( 'mpwp.metabox.events.twig.html' ,$template );
	}

	/**
	 *	@function	event_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function event_save_postdata( $post_id )
	{
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
		if ( !wp_verify_nonce( $_POST['event_noncename'], 'event_action' ) ) return;
		if ( 'page' == $_POST['post_type'] )
		{
			if ( !current_user_can( 'edit_page', $post_id ) ) return;
		}
		else
		{
			if ( !current_user_can( 'edit_post', $post_id ) ) return;
		}
		$cpc_event_date = $_POST['cpc_event_date'];
		$valid_date = preg_match( '/^[0-9]{4}[-][0-9]{2}[-][0-9]{2}$/', $cpc_event_date );
		if ( $valid_date ) @q8_save_postdata( $post_id, 'cpc_event_date', $cpc_event_date );
		$cpc_event_time = $_POST['cpc_event_time'];
		$valid_time = preg_match( '/^[0-9]{2}[:][0-9]{2}$/', $cpc_event_time );
		if ( $valid_time ) @q8_save_postdata( $post_id, 'cpc_event_time', $cpc_event_time );
		foreach( $this->langs as $lang ):
			@q8_save_postdata( $post_id, 'cpc_event_name_' . $lang, $_POST['cpc_event_name_' . $lang] ); 
			@q8_save_postdata( $post_id, 'cpc_event_location_' . $lang, $_POST['cpc_event_location_' . $lang] );
		endforeach;
		$cpc_event_location_map = $_POST['cpc_event_location_map'];
		@q8_save_postdata( $post_id, 'cpc_event_location_map', $cpc_event_location_map );
		$cpc_event_location_map_embed = strip_tags( $_POST['cpc_event_location_map_embed'], '<iframe>' );
		@q8_save_postdata( $post_id, 'cpc_event_location_map_embed', $cpc_event_location_map_embed );
	}
	/**
	 *	@function	footer_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function footer_inner_custom_box( )
	{
		$template["privacy_policy"] = get_post_meta($_REQUEST["post"],'cpc_privacy_policy',true);
		$template["contact"]        = get_post_meta($_REQUEST["post"],'cpc_contact',true);
		wp_nonce_field('footer_action', 'footer_noncename');
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.footer.twig.html',$template);
	}
	/**
	 *	@function	footer_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function footer_save_postdata( $post_id ) 
	{
		if (defined( 'DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!wp_verify_nonce( $_POST['footer_noncename'], 'footer_action')) return;
		if ('page' == $_POST['post_type'])  { if (!current_user_can('edit_page', $post_id)) return; }
		else { if (!current_user_can('edit_post', $post_id)) return; }
		if('page' == $_POST['post_type']){
			global $wpdb;
			$cpc_privacy_policy = $_POST['cpc_privacy_policy'];
			$cpc_privacy_policy_old = $_POST['cpc_privacy_policy_old'];
			if('0' == $cpc_privacy_policy) { delete_post_meta($post_id,'cpc_privacy_policy'); }
			else {
				$data = $wpdb->query($wpdb->prepare("DELETE FROM $wpdb->postmeta WHERE meta_key = '%s' AND meta_value = '%d';", 'cpc_privacy_policy', 1)); 
				update_post_meta($post_id,'cpc_privacy_policy',$cpc_privacy_policy);
			}
			$cpc_contact = $_POST['cpc_contact'];
			$cpc_contact_old = $_POST['cpc_contact_old'];
			if('0' == $cpc_contact) { delete_post_meta($post_id,'cpc_contact'); }
			else {
				$data = $wpdb->query($wpdb->prepare("DELETE FROM $wpdb->postmeta WHERE meta_key = '%s' AND meta_value = '%d';" ,'cpc_contact', 1)); 
				update_post_meta($post_id,'cpc_contact',$cpc_contact);		
			}
		}
	}
	/**
	 *	@function	subfeature_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function subfeature_save_postdata( $post_id )
	{
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!wp_verify_nonce( $_POST['subfeature_noncename'], 'subfeature_action')) return;
		if ('page' == $_POST['post_type']) { if (!current_user_can('edit_page', $post_id)) return; }
		else { if (!current_user_can('edit_post', $post_id)) return; }
		$langs = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($langs as $lang):
			@q8_save_postdata($post_id, 'cpc_subfeature_title_'.$lang, $_POST['cpc_subfeature_title_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_subfeature_excerpt_'.$lang, $_POST['cpc_subfeature_excerpt_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_subfeature_image_'.$lang, $_POST['cpc_subfeature_image_'.$lang]);
		endforeach;
	}
	/**
	 *	@function	media_inner_custom_box
	 *	@params 	void
	 *	@return 	void
	 */	
	public function media_inner_custom_box( )
	{
		$template = array( );
		$template["field"]["media_source"] = get_post_meta($_REQUEST["post"], 'cpc_media_source',true);
		$template["field"]["media_author"] = get_post_meta($_REQUEST["post"], 'cpc_media_author',true);
		$template["field"]["media_link"] = get_post_meta($_REQUEST["post"], 'cpc_media_link',true);
		$template["field"]["media_publish_date"] = get_post_meta($_REQUEST["post"], 'cpc_media_publish_date',true);
		wp_nonce_field('media_action', 'media_noncename');
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.media_release.twig.html',$template);
	}
	/**
	 *	@function	media_save_postdata
	 *	@params 	<post_id:int>
	 *	@return 	void
	 */	
	public function media_save_postdata( $post_id ) 
	{
		if (defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE) return;
		if (!wp_verify_nonce( $_POST['media_noncename'], 'media_action')) return;
		if ('page' == $_POST['post_type'])  { if (!current_user_can('edit_page', $post_id)) return; }
		else { if (!current_user_can('edit_post', $post_id)) return; }
		@q8_save_postdata($post_id, 'cpc_media_source', $_POST['cpc_media_source']);
		@q8_save_postdata($post_id, 'cpc_media_author', $_POST['cpc_media_author']);
		@q8_save_postdata($post_id, 'cpc_media_link', $_POST['cpc_media_link']);
		$cpc_media_publish_date = $_POST['cpc_media_publish_date'];
		$valid_date = preg_match('/^[0-9]{4}[-][0-9]{2}[-][0-9]{2}$/', $cpc_media_publish_date);
		if ($valid_date) @q8_save_postdata($post_id, 'cpc_media_publish_date', $cpc_media_publish_date);
	}

	public function wp_enqueue_scripts( ) 
	{
		$setting = get_option(@$this->theme_mp_social_tools);
		if ( !is_admin() ) 
		{
			wp_enqueue_script('jquery');
			wp_enqueue_script('scripts', ASSET_URL.'scripts.js?script[]=modernizr&script[]=cookies&script[]=jwplayer&script[]=fancybox', array('jquery'));
		}
		if (1 == (int)$setting["socnettoolvisible"])
		{
			wp_enqueue_script('googleplus', 'https://apis.google.com/js/plusone.js');
			wp_enqueue_script('linkedin', '//platform.linkedin.com/in.js');
		}
	}

	public function wp_enqueue_styles( ) 
	{
		if (!is_admin()) 
		{
			wp_enqueue_style('fancybox', ASSET_URL.'fancybox/fancybox.css');
		}
	}

	/**
	 *	@function	email_signup_form_submission
	 *	@params 	<r:array>
	 *	@return 	<results:array>
	 */	
	public function email_signup_form_submission( $r )
	{
		global $wpdb;
		$lang = $r['lang'];
		$fullname = $r['fullname'];
		$email = $r['email'];
		$postalcode = $r['postalcode'];
		$pid = $r['pid'];
		$ip = $r['REMOTE_ADDR'];
		$splash_type = ($r['splash_type']) ? $r['splash_type'] : 0;
		$results = array('success'=>FALSE,'message'=>NULL);
		$validemail = (is_email($email))? $email : false;
		$valid_postalcode = preg_match('/^[a-zA-Z][0-9][a-zA-Z][[:space:]]*[0-9][a-zA-Z][0-9]$/', $postalcode);
		if($fullname && $validemail && $valid_postalcode){
			$email = strtolower($email);
			if (7 == strlen($postalcode)) {
				$postalcode = substr($postalcode, 0, 3) . substr($postalcode, 4, 3);
			}
			$postalcode = strtoupper($postalcode);
			$pid = @q8_clean_post($pid);
			$splash_type = @q8_clean_post($splash_type);
			$wpdb->cpc_email_signup = $wpdb->prefix . 'cpc_email_signup';
			$new_email_signup = $wpdb->insert(
				$wpdb->cpc_email_signup,
				array(
					'name'        => $fullname,
					'email'       => $email,
					'postalcode'  => $postalcode,
					'ip'          => $ip,
					'source'      => $pid,
					'splash_type' => $splash_type
				),
				array( '%s', '%s', '%s', '%s', '%d', '%s' )
			);
			if (1 == $new_email_signup) {
				$setting2 = get_option(@$this->theme_mp_email_form_notification);
				if ((1 == (int)$setting2["notify"]) && ("" !== $setting2["to_notify_name"]) && ("" !== $setting2["to_notify_email"])) {
					$send_email = @q8_get_email_addresses($setting2["to_notify_name"],$setting2["to_notify_email"]);
					$headers = @q8_mail_headers($field_value_name,$field_value_email);
					$headers = $send_email["cc"] . $headers;
					$message ="<b>Name</b>: $fullname<br /><b>Email</b>: $email<br /><b>Postal Code</b>: $postalcode<br />";
					@wp_mail($send_email["to"], "Email Signup Form", $message . $headstuff, $headers);
				}
			}
			$results['success'] = true;
			$results['message'] = ('fr' == $lang) ?  '<p>Merci d’avoir ouvert une session</p>' : '<p>Thank you for signing up.</p>';
		} else {
			$results['message'] = ('fr' == $lang) ?  'Veuillez vous assurer de remplir tous les champs requis' : 'Please ensure all required fields are filled out correctly';
		}
		$results = json_encode($results);
		return $results;		
	}

	/**
	 *	@function	get_splash_socnets
	 *	@params 	void
	 *	@return 	<temp:string>
	 */	
	
	public function get_socnets_links( )
	{
		$links = array( );
		$socnet_types = array("facebook","twitter","flickr","youtube","rss","digg","linkedin","delicious","vimeo");
		$active_socnets = get_option( 'widget_socialnetworks' );
		if ( is_array( $active_socnets ) )
		{
			reset( $active_socnets );
			$k = key( $active_socnets );
			foreach( $active_socnets[$k] as $key => $value ):
				$temp = explode( '_', $key );
				$s = end( $temp );
				if ( in_array( $s, $socnet_types ) )
				{
					if ( $value )
					{
						$links[$s] = $value;
					}
				}
			endforeach;			
		}
		return $links;
	}
	
	public function get_splash_socnets( )
	{
		$socnet_types = array("facebook","twitter","flickr","youtube","rss","digg","linkedin","delicious","vimeo");
		$active_socnets = get_option('widget_mpwp_socialnetworks');
		if (@q8_french_enabled()) { $langurl = '<section class="grid_4 widget"><p><a href="?lang='.@q8_translate("fr","en").'">'.@q8_translate("Français","English").'</a></p></section><section class="grid_8 widget socnet">'; } else {  $langurl = '<section class="grid_8 push_4 widget socnet">'; }
		if (is_array($active_socnets)) {
			unset($active_socnets[2]['title']);
			foreach ($socnet_types as $socnet_type):
				if ($active_socnets[2]['socnet_'.$socnet_type]) {
					$links .= '<a href="'.$active_socnets[2]['socnet_'.$socnet_type].'" target="_blank" rel="nofollow" class="socnet_icon '.$socnet_type.'_icon"></a>';
				}
			endforeach;
		}
		$temp = '
			<aside class="grid_12">
				'.$langurl.'
	            	<article>
	                    <div class="socnets">
	                    	'.$links.'
	                    </div>
	               </article>
	           	</section>
	        </aside>';
		return $temp;
	}
	/**
	 *	@function	get_splash_background
	 *	@params 	void
	 *	@return 	<temp:string>
	 */	
	public function get_splash_background( )
	{
		$theme_settings = get_option( $this->theme_mp_splash_page_theme_settings );
		$temp = '
			<style> 
				#splash .ad { background:url(http:'.ASSET_URL.'splash/'.$theme_settings["theme_slug"].'.jpg) no-repeat top center; } 
				@media (max-width: 767px) {
				#splash .ad { background: none; }	
				}
			</style>';
		return $temp;
	}
	/**
	 *	@function	get_googleanalytics
	 *	@params 	void
	 *	@return 	<temp:string>
	 */	
	public function get_googleanalytics( )
	{
		$temp = false;
		$setting = get_option(@$this->theme_mp_googleanalytics);
		$setting["property_id"];
		if ($setting["property_id"]) {
			$temp .= "
	<script type=\"text/javascript\">
	var _gaq = _gaq || [];_gaq.push(['_setAccount', '".$setting["property_id"]."']);_gaq.push(['_trackPageview']);
	(function() {
	var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	})();
	</script>";
		}
		return $temp;
	}
	/**
	 *	@function	get_subpage_links
	 *	@params 	<post_id:int>
	 *	@return 	<temp:string>
	 */	
	public function get_subpage_links( $post_id )
	{
		global $wpdb,$post; 
		$temp = NULL;
		$cpc_menu_item_name = @q8_translate('cpc_menu_item_name_en','cpc_menu_item_name_fr');
		$query = new WP_Query(array('post_type'=>'page','post_parent'=>$post_id,'posts_per_page'=>-1,'orderby'=>'title','order'=>'ASC'));
		while ($query->have_posts()) : $query->the_post();
			$custom_subname = get_post_meta($query->post->ID,$cpc_menu_item_name,true);
			$subname = ($custom_subname) ? $custom_subname : get_the_title($query->post->ID);
			$external_sublink = get_post_meta($query->post->ID,'cpc_menu_item_link',true);
			$get_sublink = get_permalink($query->post->ID);
			$sublink = ($external_sublink) ? $external_sublink : $get_sublink;
			$sublink_target = ($external_sublink) ? 'target="_blank"' : NULL;
			$temp .= '<p><a href="'.$sublink.'" '.$sublink_target.'>'.$subname.'</a></p>';
		endwhile; wp_reset_postdata();
		return $temp;
	}
	/**
	 *	@function	get_subpage_links
	 *	@params 	<cat_id:int>
	 *				<post_id:int>
	 *	@return 	<subpage_image:string>
	 */	
	public function get_subpage_image( $slug, $post_id )
	{
		$setting = get_option(@$this->theme_mp_general_config);
		if (1 == (int)$setting["subpage_image"]) {
			if ($slug == $this->categories['feature-article']) {
				$cpc_feature_image_en = get_post_meta($post_id, @q8_translate('cpc_feature_image_en','cpc_feature_image_fr'), true);
				$subpage_image = ($cpc_feature_image_en) ? '<img src="'.$cpc_feature_image_en.'" border="0" class="align-left" />' : false;
			}
			if ($slug == $this->categories['subfeature'] && !$subpage_image) {
				$cpc_subfeature_image_en = get_post_meta($post_id,  @q8_translate('cpc_subfeature_image_en','cpc_subfeature_image_fr'), true);
				$subpage_image = ($cpc_subfeature_image_en) ? '<img src="'.$cpc_subfeature_image_en.'" border="0" class="align-left" />' : false;
			}
		}
		return $subpage_image;
	}
	/**
	 *	@function	help
	 *	@params 	<text:string>
	 *				<screen:text>
	 *	@return 	<text:string>
	 */	
	public function help( $text, $screen )
	{
		if ('edit-post' == $screen) {
			
			$text = '<p>' . __('Quick Edit provides inline access to the metadata (categories, author, etc.) of your post, allowing you to update post details without leaving this screen.') . '</p>';
			
			$text .= '<p>' . __('You can also edit multiple posts at once. Select the posts you want to edit using the checkboxes, select Edit from the Bulk Actions menu and click Apply. You will be able to change the metadata for all selected posts at once. To remove a post from the grouping, just click the x next to its name in the Bulk Edit area that appears.') . '</p>';
			
		
		}
		
		if ('post' == $screen) {
			
			$text = '<p>' . __('
	The title field and the big Post Editing Area are fixed in place, but you can reposition all the other boxes (such as Publish and Categories) using drag and drop, and can minimize or expand them by clicking the title bar of each box.');
			
			$text .= '<p><strong>'. __('Publish'). '</strong>' . __(' - You can set the terms of publishing your post in the Publish box. For Status, Visibility, and Publish (immediately), click on the Edit link to reveal more options. Status allows you to select your post as a draft or pending review so that others who you’ve give access to can review the post before it is made public. Visibility includes options for password-protecting a post or making it stay at the top of your blog indefinitely (sticky). Publish (immediately) allows you to set a future or past date and time, so you can schedule a post to be published in the future or backdate a post.') . '</p>';
			
			$text .= '<p>' . __('To link a Call to Action onto a feature story you’ve already created, you must create a ‘call to action’ post. Give this post/action a name, outline details in the text box, select the call to action category and publish. You then must go to the feature story post you want this call of action to be displayed on and linked to (if this post is not yet created, make one). Underneath the text box of your feature story, you will see a list of Feature Article Options. The last two options allow you to select a name for your call to action and then you can choose the call to action post you want to be linked to this article. ') . '</p>';
			
			$text .= '<p>' . __('Click on any of the following links to get an idea of where a relative categorized POST would end up'). ':<br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_cta.jpg" rel="posts_help_cta">' . __('Call To Action'). '</a><br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_newsfeed.jpg" rel="posts_help_newsfeed">' . __('Display On Homepage News Feed'). '</a><br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_feature.jpg" rel="posts_help_feature">' . __('Feature (Article)'). '</a><br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_subfeature.jpg" rel="posts_help_subfeature">' . __('Sub Feature'). '</a>' . '</p>';
			
			$text .= '
	        <a id="cpc_category_reminder" href="#cpc_category_reminder_text"></a>
			<div style="display:none;">
	        	<div id="cpc_category_reminder_text">
	                <p>You selected a category to associate with the post. To ensure it appears on your website, create a PAGE that lists articles with the category you\'ve chosen.<br /><br />
	                    <a href="javascript:;" onclick="$js_.fancybox.close();">Hmm, keep reminding me.</a>&nbsp; | &nbsp;
	                    <a href="javascript:;" onclick="$js_.fancybox.close();$js_.cookie(\'cpc_category_reminder\',\'never\', { expires: 365 });">Got it, don\'t remind me again.</a>
	                </p>
	            </div>
	        </div>
			';
		}
		
		if ('widgets' == $screen) {
			$text = '<p><strong><a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_widget.jpg" rel="posts_help_widget">'. __('Widgets'). '</a></strong>' . __(' are independent sections of content that can be placed on the sidebar of your website. To visitors, widgets will appear as a variety of different things including visuals that can be clicked on which brings them to a page/post on your site, a video player displaying a video you want people to see or it can even display your social networks. Simply drag, from the list of options below, the content you want to the sidebar on the right and this will activate the widget you have chosen.') . '</p>';
			
			$text .= __('If you would like to create a link to an external website or article, select the promotional graphic/link option. It will ask you to insert the link to your graphic, which you can do by uploading the photo into your Media library. Once the photo is there, it will show you a URL link – this is what you insert as the link to your graphic. It will also ask for a link to the website/article, which is in the URL field, at the top of the page of your desired website/article.') . '</p>';
			
			$text .= '<p>' . __('Click on any of the following links to get an idea of whereabouts the sidebar is or widgets are located'). ':<br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_sidebar.jpg" rel="posts_help_sidebar">' . __('Sidebar'). '</a><br /><br />
								<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_widget.jpg" rel="posts_help_widget2">' . __('Widgets'). '</a>' . '</p>';
			
		}
		
		if ('edit-page' == $screen) {
			$text = '<p><strong>'. __('Pages'). '</strong>' . __(' are similar to Posts in that they have a title, body text, and associated metadata, but they are different in that they are not part of the chronological blog stream, kind of like permanent posts. Pages are not categorized or tagged, but can have a hierarchy. You can nest Pages under other Pages by making one the “Parent” of the other, creating a group of Pages. For instance, if you have a News page, you may want to nest Local News and National News pages underneath your News page, by making your News page the “Parent” of your Local and National news pages.') . '</p>';
			
			$text .= '<p>' . __('Managing Pages is very similar to managing Posts, and the screens can be customized in the same way.  You can also perform the same types of actions, including narrowing the list by using the filters, acting on a Page using the action links that appear when you hover over a row, or using the Bulk Actions menu to edit the metadata for multiple Pages at once.') . '</p>';
			
		}
		
		if ('page' == $screen) {
			$text = '<p>' . __('There are a number of different options along the right hand side when creating a page.') . '</p>';
			
			$text .= '<p>' . __('Under Publish you can preview your page and the changes you’ve made as well as determine a particular date to publish the page if you do not want it published immediately.') . '</p>';
			
			$text .= '<p>' . __('Under Page Attributes, you can select if this page should have a Parent page. In the previous example, if you were creating your Local or National News page, you would select your previously made News page as the parent.') . '</p>';
			
			$text .= '<p>' . __('When creating a new page you will be asked to select a Template on the right-hand sidebar. You can select Contact, Events, News and Video Gallery if your newly created page is for one of these categories. Alternatively, you can select custom categories if none of these templates describes what the page you are creating is for. If you select custom, you will then have to choose one or more of the Custom Categories Options that is directly below the text box. You must decide what types of posts you want to go on this newly created page by selecting the corresponding categories. For example, if you want to create a page of press releases, you would select Custom Categories and then select Press Releases in the custom category options. If you want both press releases and speeches to go on this page, you would select both of those options. When you then create a post and select the post’s categories, that post will go on the pages in which you’ve selected those matching categories.') . '</p>';
			
			$text .= '<p><strong>'. __('Menu Options'). '</strong>' . __(' - Under Menu Options, you must select whether or not you want this new page to appear in your main menu that is located on the top bar of your website (i.e., the header).  ') . 
			'<a href="'.MPWEB_TEMPLATE_DIR_IMAGES.'/posts_help_menu.jpg" rel="posts_help_menu">' . __('Click here to see whereabouts it would appear on your website'). '</a>'.
			'</p>';
			
			$text .= '<p><strong>'. __('Footer Options'). '</strong>' . __(' - Finally, the Footer Option is only used when the page you are adding is either your personalized Privacy Policy or your personalized Contact page.') . '</p>';
			
			$text .= '
	        <a id="cpc_photogallery_reminder" href="#cpc_photogallery_reminder_text"></a>
			<div style="display:none;">
	        	<div id="cpc_photogallery_reminder_text">
	                <p>You are on the Photo Gallery page. <a href="themes.php?page=mpwp-settings-5">Click here</a> to go to the Photo Gallery section to add photos.<br /><br />
	                    <a href="javascript:;" onclick="$js_.fancybox.close();">Hmm, keep reminding me.</a>&nbsp; | &nbsp;
	                    <a href="javascript:;" onclick="$js_.fancybox.close();$js_.cookie(\'cpc_photogallery_reminder\',\'never\', { expires: 365 });">Don\'t remind me again.</a>
	                </p>
	            </div>
	        </div>
	        <a id="cpc_videogallery_reminder" href="#cpc_videogallery_reminder_text"></a>
			<div style="display:none;">
	        	<div id="cpc_videogallery_reminder_text">
	                <p>You are on the Video Gallery page. <a href="themes.php?page=mpwp-settings-4">Click here</a> to go to the Video Gallery section to add videos.<br /><br />
	                    <a href="javascript:;" onclick="$js_.fancybox.close();">Hmm, keep reminding me.</a>&nbsp; | &nbsp;
	                    <a href="javascript:;" onclick="$js_.fancybox.close();$js_.cookie(\'cpc_videogallery_reminder\',\'never\', { expires: 365 });">Don\'t remind me again.</a>
	                </p>
	            </div>
	        </div>
			';

		}
		
		if ('upload' == $screen) {
			$text = '<p><strong>'. __('Media Library'). '</strong>' . __(' - All the files you’ve uploaded are listed in the Media Library, with the most recent uploads listed first.') . '</p>';
			
			$text .= '<p>' . __('You can narrow the list by file type/status using the text link filters at the top of the screen.  You also can refine the list by date using the dropdown menu above the media table.') . '</p>';
			
			$text .= '<p>' . __('Hovering over a media file’s row reveals action links: Edit, Delete Permanently, and View. Clicking Edit or on the media file’s name displays a simple screen to edit that individual file’s metadata. Clicking Delete Permanently will delete the file from the media library (as well as from any posts to which it is currently attached). View will take you to the display page for that file.') . '</p>';
			
		}
		
		if ('media' == $screen) {
			$text = '<p><strong>'. __('Upload New Media'). '</strong>' . __(' - You can upload media files here without creating a post first. This allows you to upload files to use with posts and pages later and/or to get a web link for a particular file that you can share.') . '</p>';
			
			$text .= '<p>' . __('There are two options for uploading files: Select Files will open the Flash-based uploader (where you can upload multiple files), or you can use the Browser Uploader. Clicking Select Files opens a navigation window showing you files in your operating system. Selecting Open after clicking on the file you want activates a progress bar on the uploader screen. Basic image editing is available after upload is complete. Make sure you click Save before leaving this screen.') . '</p>';
			
		}
		
		if ('dashboard' == $screen) {
			$setting = get_option(@$this->theme_mp_getting_started);
			if (1 != (int)$setting["website_setup"]) {
				$text = '<p><strong>'. __('Getting Started'). '</strong><p>';
				$text .= '<p>' . __('If you would like to quickly get started on your website and want a template so that you can just incorporate your content, it is probably best to install default settings. Installing these settings will give you <b>7 pages</b> (Home, About, News, Riding, Media, Resources and Contact), <b>6 articles</b> (two feature stories, two sub-features and 2 national news items) as well as some <b>generic content</b> (Welcome message, Privacy Policy and Contact). Keep in mind that these items and their content can always be changed when you wish to do so, it is used only as a quick set-up for your website.') . '</p>';
				
				$text .= '<p>' . __('If you are experienced in WordPress or in operating a website, you may choose not to install these default settings and begin setting up your website on your own. You will need to add pages, posts and all of the generic content manually.') . '</p>';
			}
			else {
				
				$text = '<p>' . __('Welcome to your website! You can get started on customizing your site by creating pages and posts, as well as by adding pictures, videos, PDFs and other media files. These are all located on the sidebar on your left-hand side.') . '</p>';
				
				$text .= '<p><strong><a href="edit.php">'. __('Posts'). '</a></strong>' . __(' - are the actual content you put on your website and they go on the specific pages of your site. Types of posts vary from articles and press releases to events and feature videos. Where your posts go on your website depends on the category you choose for the post. For instance, if you select News as a category, that post will be displayed on your News page. You are able to determine which categories are displayed on which page; this is explained underneath the Page Add-New help menu. To add a new post, click ‘add-new’ underneath Posts on the left-hand side. For more information on categories, click categories underneath Posts and refer to the help menu on that page.') . '</p>';
				
				$text .= '<p><strong><a href="edit.php?post_type=page">'. __('Pages'). '</a></strong>' . __(' - help you organize your website based on the content you put on it. Default settings gives you 7 pages including a page of news content, a multimedia page with all the media you want to share and a page with your contact information. You can create additional pages and subpages (pages that appear as a subordinate to the pages listed on your header) by clicking the ‘add-new’ option underneath Pages on the sidebar. You will then be asked to choose the categories you want associated with this page.  Be careful not to add too many pages as your website may start to look too busy.') . '</p>';
				
				$text .= '<p><strong><a href="widgets.php">'. __('Sidebar'). '</a></strong>' . __(' - is a menu that runs vertically along one side of a website. On your website, the side bar runs along the right-hand side. The side bar is filled with <strong>widgets</strong>, which are the actual menu choices you make available for visitors to view. A <strong>widget</strong> can be a video, a written message, or even a link to another website or article. If you would like to change the widgets on your sidebar, you will see the Widgets option on the left-hand side, underneath Appearance.') . '</p>';
				
				$text .=  __('For more information on all of these topics, simply go to topic you wish to know more about and there will be a help menu geared specifically toward that subject.') . '</p>';
			}
			
		}
		
		if ('edit-category' == $screen) { // Need more details
			$text = '<p><strong>'. __('Categories'). '</strong>' . __(' allow you to easily categorize the content of your website onto the appropriate pages of your website. For instance, all news items you post should appear on your News page. Additionally, it can be added to your homepage if it is an important news item you want visitors to your site to see.') . '</p>';
			
			
			
			$text .= '<p>' . __(' There are over 10 categories to choose from. <strong>Feature stories</strong> are stories/articles that are predominant in the media and important for the public to know. These will automatically appear on your homepage. <strong>Feature videos</strong> are essentially the same in a video format. A <strong>sub-feature</strong> is a story that is also significant, but may either be a little less important than the main feature or more outdated. This will also appear on your homepage, but will be placed underneath your main feature story. The <strong>display on homepage</strong> category allows you to choose which posts you want on your homepage. This option allows you to decide which posts are important for visitors of your site to see immediately, whether that is an event, article or press release.') . '</p>';
			
			$text .= '<p><strong>'. __('Call to action'). '</strong>'  . __(' is a category that can be linked to a feature story post when you want people to take action on a certain topic. For instance, if you post a press release regarding Remembrance Day, you may want to link a call to action post to this explaining to people where they can go in your riding to pay their respects. The call to action option will be displayed on your feature story as a clickable button that brings the visitor to another page describing the event that is related to this article. For more information on how to do this, please refer to the help menu in the ‘add-new’ Post section.') . '</p>';
			
			$text .= '<p>' . __(' The category you choose for a post will determine where on your website that post goes. For instance, if you create a post and select Feature (Article) or Sub Feature, that post will appear on your home page. Alternatively, if you select News (Local or National) as your category, this post will appear on your news page. You can select more than one page for a certain post to appear and you can also specify if you want a particular post to appear on your homepage by selecting Display on Homepage. If you decide you want to select op-ed, press release or speech as a category, you must first create a page for one or more of these categories, as these pages are not generated from the default settings. If you do not create these pages, the post will not appear anywhere on your website. For information on how to create a page, go to the help menu under <a href="post-new.php?post_type=page">Page – Add New</a>.') . '</p>';
			
			$text .= '<p><strong>'. __('Slug'). '</strong>' . __(' - The “slug” is the URL-friendly version of the name. It is usually all lowercase and contains only letters, numbers, and hyphens. This is what will appear in the link of your article.') . '</p>';
			
			$text .= '<p><strong>'. __('Parent'). '</strong>' . __(' - Categories, unlike tags, can have a hierarchy. You might have a News category, and under that have children categories for Local and National news. This is totally optional. To create a subcategory, just choose another category from the Parent dropdown.') . '</p>';
		}
		
		if ('themes' == $screen) { 
			$text = '<p><strong>'. __('Themes'). '</strong>' . __(' - Aside from the default theme included with your WordPress installation, themes are designed and developed by third parties.') . '</p>';
			
			$text .= '<p>' . __('You can see your active theme at the top of the screen. Below are the other themes you have installed that are not currently in use. You can see what your site would look like with one of these themes by clicking the Preview link. To change themes, click the Activate link.') . '</p>';
		
			$text .= '<p>' . __('There are two options for uploading files: Select Files will open the Flash-based uploader (where you can upload multiple files), or you can use the Browser Uploader. Clicking Select Files opens a navigation window showing you files in your operating system. Selecting Open after clicking on the file you want activates a progress bar on the uploader screen. Basic image editing is available after upload is complete. Make sure you click Save before leaving this screen.') . '</p>';
			
		}
		
		if ('plugins' == $screen) { 
			$text = '<p><strong>'. __('Plugins'). '</strong>' . __(' - Plugins extend and expand the functionality of WordPress. Once a plugin is installed, you may activate it or deactivate it here.') . '</p>';
			
		}
		
		return $text;
	}
	/**
	 *	@function	my_admin_notice
	 *	@params 	void
	 *	@return 	void
	 */	
	public function my_admin_notice( )
	{
		global $current_screen;
		$setting = get_option(@$this->theme_mp_getting_started);
		if ((1 != (int)$setting["website_setup"]) && ("dashboard" != $current_screen->base)) {
			echo '<div class="updated oneclickstart"><p><a href="index.php">'.__('You have yet to activate your website. Click here to go to the Dashboard and set up your website in two easy steps.').'</a></p></div>';
		}
	}
	/*
	 *	CHILD FUNCTIONS
	 */
	const emailsignupShortcode = "EMAILSIGNUP";

	/* MPWP */
	public function sidebar_widgets() 
	{
		unregister_widget('WP_Widget_Calendar');
		unregister_widget('WP_Widget_Search');
		unregister_widget('WP_Widget_Recent_Comments');
		unregister_widget('WP_Widget_Categories');
		unregister_widget('WP_Widget_Links');
		unregister_widget('WP_Widget_Meta');
		unregister_widget('WP_Widget_Pages');
		unregister_widget('WP_Widget_Recent_Posts');
		unregister_widget('WP_Widget_RSS');
		unregister_widget('WP_Widget_Tag_Cloud');
		unregister_widget('WP_Widget_Text');
		unregister_widget('WP_Widget_Archives');
		unregister_widget('WP_Widget_Custom_Menu');
		wp_register_sidebar_widget('cpc_mp_search_widget_1','Search', array($this,'search_widget'),array('description'=>__('Add a search input box to allow visitors to search for content within your website')),array('before_widget'=>'', 'after_widget'=>'', 'before_title'=>'', 'after_title'=>'',));
		wp_register_widget_control('cpc_mp_search_widget_1','Search',array($this,'search_widget_controls'));
		wp_register_sidebar_widget('cpc_mp_emailsignup_widget_1','E-mail Signup', array($this,'emailsignup_widget'),array('description'=>__('Add the E-mail Signup widget to your footer sidebar')),array('before_widget'=>'', 'after_widget'=>'', 'before_title'=>'', 'after_title'=>'',));
		wp_register_sidebar_widget('cpc_mp_photo_gallery_widget_1','Photo Gallery', array($this,'photo_gallery_widget'),array('description'=>__('Add a snippet of the Photo Gallery')),array('before_widget'=>'', 'after_widget'=>'', 'before_title'=>'', 'after_title'=>'',));
		wp_register_widget_control('cpc_mp_photo_gallery_widget_1','Photo Gallery',array($this,'photo_gallery_widget_controls'));
	}
	public function photo_gallery_widget( $args, $instance )
	{
		global $wpdb;
		$template = array( );
		extract($args);
		$s = trim($_REQUEST["s"]);
		$o = get_option('cpc_photo_gallery_widget_options');
		$template["before_widget"] = $before_widget;
		$template["before_title"] = $before_title;
		$template["title"] = $o["cpc_photo_gallery_widget_title_en"];
		$template["after_title"] = $after_title;
		if (is_numeric($o['cpc_photo_gallery_widget_album'])) {
			$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
			$photos = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery WHERE gallery_id = ".$o['cpc_photo_gallery_widget_album'].";");
			$y=0;
			$setting = get_option(@$this->theme_mp_photo_gallery_config);
			$size = ($setting["image_size"]) ? $setting["image_size"] : 'large';
			$images = array( );
			foreach ($photos as $photo):
				$image = wp_get_attachment_image_src( $photo->image_id, $size );
				$image_thumbnail = wp_get_attachment_image_src( $photo->image_id, 'thumbnail' );
				if ($image) {
					$info = get_post($photo->image_id);
					$images[$y]["title"] = esc_attr($info->post_title);
					$images[$y]["src"] = $image[0];
					$images[$y]["src_thumb"] = $image_thumbnail[0];
					$y++;
				}
			endforeach;
			$template["images"] = $images;
			$template["after_widget"] = $after_widget;
		}
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.photogallery.twig.html',$template);
		}
	}
	public function photo_gallery_widget_controls( )
	{
		global $wpdb;
		$template = array( );
		$template["hidden_field_name"] = 'cpc_photo_gallery_widget_form';
		if (isset($_POST[$template["hidden_field_name"]])) {
            update_option(
            	'cpc_photo_gallery_widget_options', 
            	array(
					"cpc_photo_gallery_widget_title_en" => @q8_clean_post($_POST['cpc_photo_gallery_widget_title_en']),
					"cpc_photo_gallery_widget_album"    => @q8_clean_post($_POST['cpc_photo_gallery_widget_album'])
            		)
            	);
        }
        $template["options"] = get_option('cpc_photo_gallery_widget_options');
		$wpdb->cpc_photo_gallery_id = $wpdb->prefix . 'cpc_photo_gallery_id';
        $template["galleries"] = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery_id ORDER BY gallery_date DESC");
		if ($template["galleries"]) {
			$i = 0;
			foreach ($template["galleries"] as $gallery):
				$template["image"][$i]["selected"] = ($template["options"]["cpc_photo_gallery_widget_album"] == $gallery->id) ? 'checked="checked"' : NULL;
				$template["image"][$i]["src"] = wp_get_attachment_image($gallery->gallery_thumbnail,array(30,30));
				$i++;
			endforeach;
		}
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.widgetform.photogallery.twig.html',$template);
	}
	public function get_category_id( $cat_name )
	{
		$term = get_term_by('slug', $cat_name, 'category');
		return $term->term_id;
	}
	public function admin_footer( )
	{
		global $current_screen;
		?>
		<script type="text/javascript">
			function add_splash_theme() {
				var no_of_available_themes = jQuery('#no_of_available_themes').val();
				var inc = parseFloat(no_of_available_themes) + 1;
				<?php 
					$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
					$splash_theme = $twig->render('mpwp.partial.splash_theme.twig.html',array("x" => "'+ inc +'"));
					$splash_theme = str_replace(array("\r\n", "\r", "\n"), " ", $splash_theme);
				?>
				var splash_theme = '<?php echo $splash_theme;?>';
				jQuery('#theme_options_container').append(splash_theme); 
				no_of_available_themes = (no_of_available_themes - 1) + 2;
				jQuery('#no_of_available_themes').val(no_of_available_themes);
			}
			function thumbnail_selection(id) {
				if(document.getElementById('pg_'+id).checked) {
					document.getElementById('pg_radio_'+id).style.display = 'block';
				}
				else {
					document.getElementById('pg_thumb_'+id).checked = false;
					document.getElementById('pg_radio_'+id).style.display = 'none';
				}
			}
			
			function validate_remove(media) {var r=confirm("Are you absolutely sure you want to remove this "+media+" ?");if (r==true) {return true;} else {return false;}}
			
			function cpc_remove_video(caption) {var r=confirm("Are you certain that you want to remove this '"+caption+"' video ?");if (r==true) {return true;} else {return false;}}
			
			function ready_to_auto_setup() {var cpc_ready_auto=confirm("Are you sure you're ready to set up your default website?");if (cpc_ready_auto==true) {return true;} else {return false;}}
			
			function ready_to_self_setup() {var cpc_ready_self=confirm("Are you sure you're ready to set up your website on your own?");if (cpc_ready_self==true) {return true;} else {return false;}}
			
			function category_reminder() {
				cpc_category_reminder = $js_.cookie('cpc_category_reminder');if (cpc_category_reminder == null) {$js_("#cpc_category_reminder").fancybox({'modal' : true});$js_('#cpc_category_reminder').trigger('click');}}

			$js_=jQuery.noConflict();
			$js_(document).ready(function() {

				jQuery(document).on('click', '.feature_upload', function(e){
					e.preventDefault();
					var data = jQuery( this ).data( ),
						lang = data.lang;

					previewthumb_file_frame = wp.media.frames.previewthumb_file_frame = wp.media({
						title: data.uploader_title,
						button: {
						text: data.uploader_button_text,
						},
						multiple: false
					});

					previewthumb_file_frame.on( 'select', function() { 
						attachment = previewthumb_file_frame.state().get('selection').first().toJSON();
						jQuery('#'+data.uploader_field).val(attachment.url);
						jQuery('#'+data.uploader_preview).html('').append('<img id="image_'+attachment.id+'" src="'+attachment.url+'" /><br /><a href="#" class="feature_remove" data-image_id="image_'+attachment.id+'" data-image_field="'+data.uploader_field+'" >Remove image</a>');
					});
					previewthumb_file_frame.open();
				});

				jQuery(document).on('click','.feature_remove', function(e){
					e.preventDefault();
					var data = jQuery( this ).data( );
					jQuery('#'+data.image_field).val('');
					jQuery('#'+data.image_id).remove();
					jQuery( this ).remove();
				});

				$js_("#cpc_select_startup_riding").change(function() {
					this_riding_id = $js_(this).val();
					$js_("#cpc_selected_startup_riding_auto").val(this_riding_id);
					$js_("#cpc_selected_startup_riding_self").val(this_riding_id);
				});
				
				<?php
				$pg_temp = get_post_meta($_REQUEST["post"], '_wp_page_template',true);
				if ("template-photo-gallery.php" == $pg_temp) { ?>
				cpc_photogallery_reminder = $js_.cookie('cpc_photogallery_reminder');
				if (cpc_photogallery_reminder == null) {
					$js_("#cpc_photogallery_reminder").fancybox({'modal' : true});
					$js_('#cpc_photogallery_reminder').trigger('click');
				}
				<?php } ?>

				<?php
				$pg_temp = get_post_meta($_REQUEST["post"], '_wp_page_template',true);
				if ("template-video-gallery.php" == $pg_temp) { ?>
				cpc_videogallery_reminder = $js_.cookie('cpc_videogallery_reminder');
				if (cpc_videogallery_reminder == null) {
					$js_("#cpc_videogallery_reminder").fancybox({'modal' : true});
					$js_('#cpc_videogallery_reminder').trigger('click');
				}
				<?php } ?>
				
				<?php
					$feature_id = @$this->get_category_id(@$this->categories["feature-article"]);
					$subfeature_id = @$this->get_category_id(@$this->categories["subfeature"]);
					$media_release_id = @$this->get_category_id(@$this->categories["media-release"]);
					$events_id = @$this->get_category_id(@$this->categories["events"]);
					$news_riding_id = @$this->get_category_id(@$this->categories["news-riding"]);
					$news_government_id = @$this->get_category_id(@$this->categories["news-government"]);
					$op_ed_id = @$this->get_category_id(@$this->categories["op-ed"]);
					$press_release_id = @$this->get_category_id(@$this->categories["press-release"]);
					$speeches_id = @$this->get_category_id(@$this->categories["speeches"]);
				?>
				$js_("#cpc_startup_reminder").fancybox({'modal' : true});
				$js_('#cpc_startup_reminder').trigger('click');
				
				$js_("a[rel=posts_help_cta]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_feature]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_newsfeed]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_subfeature]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_sidebar]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_widget]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_widget2]").fancybox({"openEffect":"none","closeEffect":"none"});
				$js_("a[rel=posts_help_menu]").fancybox({"openEffect":"none","closeEffect":"none"});
				
				$js_("#cpc_video_date").datepicker({dateFormat:'yy-mm-dd'});
				$js_('.trigger-show-settings').click(function() {
					$js_('#contextual-help-link').trigger('click');
					return false;
				});
				$js_("#cpc_photo_gallery_date").datepicker({dateFormat:'yy-mm-dd'});
				$js_(".cpc_update_video_date").datepicker({dateFormat:'yy-mm-dd'});
				
				$js_("#in-category-<?php echo $subfeature_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $subfeature_id;?>:checked").val() !== undefined) {
						$js_("#cpc_subfeature_options").show();
					}
					else {
						$js_("#cpc_subfeature_options").hide();
					}
				});
				$js_("#in-category-<?php echo $media_release_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $media_release_id;?>:checked").val() !== undefined) {
						$js_("#cpc_media_release_options").show();
						category_reminder();
					}
					else {
						$js_("#cpc_media_release_options").hide();
					}
				});
				
				$js_("#in-category-<?php echo $feature_id; ?>").click(function() {
					if ($js_("#in-category-<?php echo $feature_id; ?>:checked").val() !== undefined) {
						$js_("#cpc_feature_options").show();
					}
					else {
						$js_("#cpc_feature_options").hide();
					}
				});
				$js_("#in-category-<?php echo $events_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $events_id;?>:checked").val() !== undefined) {
						$js_("#cpc_event_options").show();
						category_reminder();
					}
					else {
						$js_("#cpc_event_options").hide();
					}
				});
				<?php /* $js_("#in-category-<?php echo $events_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $events_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				}); */ ?>
				$js_("#in-category-<?php echo $news_riding_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $news_riding_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				});
				$js_("#in-category-<?php echo $news_government_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $news_government_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				});
				$js_("#in-category-<?php echo $op_ed_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $op_ed_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				});
				$js_("#in-category-<?php echo $press_release_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $press_release_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				});
				$js_("#in-category-<?php echo $speeches_id;?>").click(function() {
					if ($js_("#in-category-<?php echo $speeches_id;?>:checked").val() !== undefined) {
						category_reminder();
					}
				});
				<?php if ("post" == $current_screen->base) { ?>
				<?php
				$post_categories = wp_get_post_categories(trim($_REQUEST["post"]));
				$cats = array();
				foreach($post_categories as $c){
					$cat = get_category($c);
					if ("subfeature" == $cat->slug) {
						echo '$js_("#cpc_subfeature_options").show();'.chr(13);
					}
					if ("media-release" == $cat->slug) {
						echo '$js_("#cpc_media_release_options").show();'.chr(13);
					}
					if ("feature-article" == $cat->slug) {
						echo '$js_("#cpc_feature_options").show();'.chr(13);
					}
					if ("events" == $cat->slug) {
						echo '$js_("#cpc_event_options").show();'.chr(13);
					}
				}
				?>
				$js_("#cpc_event_date").datepicker({dateFormat:'yy-mm-dd'});
				$js_("#cpc_event_time").timepicker();
				$js_("#cpc_media_publish_date").datepicker({dateFormat:'yy-mm-dd'});
				<?php } ?>
				
			});
		</script>
		<?php
	}
	public function panel_hot_topics_setting() 
	{
		$msg = NULL;
		$template = array( );
		$template["hidden_field_name"] = "hot_topics_setting";
		if (isset($_POST[$template["hidden_field_name"]])) {
			$visible = ($_POST["visible"]) ? 1 : 0;
			$button_en = @q8_clean_post($_POST["button_en"]);
			$button_fr = (@q8_french_enabled()) ? @q8_clean_post($_POST["button_fr"]) : $button_en;
			if (1 == $visible) {
				
			}
			if ($_POST["categories"]) {
				foreach ($_POST["categories"] as $b):
					$categories .= $b.",";
				endforeach;
				$categories = ($categories) ? substr($categories,0,-1) : $categories;
			}
			update_option(@$this->theme_mp_hot_topics, array('visible'=>$visible,'categories'=>$categories,'button_en'=>$button_en,'button_fr'=>$button_fr));
			$template["msg"] = '<div class="alert alert-success"><p>'.__('Settings updated').'</p></div>';
		}
		$template["setting"] = get_option(@$this->theme_mp_hot_topics);
		$cats = get_categories();
		$c = explode(",",$template["setting"]["categories"]);
		foreach ($cats as $cat) :
			$checked = (in_array($cat->term_id,$c)) ? 'checked="checked"' : NULL;
			$template["options"] .= '<div><label for="category'.$cat->term_id.'"><input type="checkbox" id="category'.$cat->term_id.'" name="categories[]" value="'.$cat->term_id.'" '.$checked.' />&nbsp;'.$cat->cat_name.'</label></div>';
		endforeach;
		$template["langs"] = (q8_french_enabled()) ? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["button"] = $template["setting"]["button_".$lang];
		endforeach;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.panel.hot_topics.twig.html',$template);
	}
	/*
	 *	@func 		get_video_gallery
	 * 	@desc 		prepares all need variables into a template array. Template is defined in child theme.
	 */
	public function get_video_gallery( ) 
	{ 
		global $wpdb;
		$template = $playlist = array( );
		$x = 0;
		$w = ( -1 );
		$feature_id = 0;
		$url = get_permalink();
		$pg = (strpos($url, '=')) ? "&stranica=": "?stranica=";
		$wpdb->cpc_video_gallery = $wpdb->prefix.'cpc_video_gallery';
		$r = $wpdb->get_results("SELECT * FROM $wpdb->cpc_video_gallery WHERE visible = 1 ORDER BY video_date DESC;");
		$total_records = $wpdb->num_rows;
		$how_many_records_to_display = 10;
		if (isset($_REQUEST["stranica"])) {
			$from_num = ($_REQUEST["stranica"] * $how_many_records_to_display) - $how_many_records_to_display;
			$to_num = ($_REQUEST["stranica"] * $how_many_records_to_display);
			if (is_numeric($_REQUEST["stranica"])) {
				$prev_page = (0 >= ($_REQUEST["stranica"] - 1)) ? 1 : ($_REQUEST["stranica"] - 1);
				$next_page = $_REQUEST["stranica"] + 1;
			}
		}
		else {
			$next_page = 2;
			$from_num = 0;
			$to_num = $how_many_records_to_display;
		}
		$pages = ceil($total_records / $how_many_records_to_display);
		$prev_page = ((1 == $pages) || (1==$_REQUEST["stranica"]) || (!isset($_REQUEST["stranica"]))) ? NULL : '<li class="previous"><a href="'.$url.$pg.$prev_page.'">&larr; '.@q8_translate("Newer Videos","Vidéos plus récentes").'</a></li>';
		$next_page = (($next_page > $pages) || (1 == $pages))  ? NULL : '<li class="next"><a href="'.$url.$pg.$next_page.'">'.@q8_translate("Older Videos"," Vidéos plus anciennes").' &rarr;</a></li>';
		$template["pagination"] = '<div class="clr"></div><ul class="pager"> '.$prev_page.$next_page.'</ul>';
		
		$feature_video = $wpdb->get_row("SELECT * FROM $wpdb->cpc_video_gallery WHERE visible = 1 AND video_feature = 1;");
		if ($feature_video) {
			if ($feature_video->video_id && (0 != $feature_video->video_id)) {
				$vid = get_post($feature_video->video_id);
				$file = $vid->guid;
				$image = '';
				$provider = 'video';
				if ($feature_video->video_image_id) {
					$img = get_post($feature_video->video_image_id);
					$image = $img->guid;
				}
			}
			if ($feature_video->video_youtube_id) {
				$file = 'http://www.youtube.com/watch?v='.$feature_video->video_youtube_id;
				$image = 'http://img.youtube.com/vi/'.$feature_video->video_youtube_id.'/0.jpg';
				$provider = 'youtube';
			}
			$feature_id = $feature_video->id;
			$playlist[] = ' { "provider": "'.$provider.'", "title": "'.esc_attr($feature_video->video_caption_en).'", "file": "'.$file.'", "image": "'.$image.'" },';
			$x++;
		}
		
		$videos = $wpdb->get_results("SELECT * FROM $wpdb->cpc_video_gallery WHERE visible = 1 AND video_feature <> 1 ORDER BY video_date DESC LIMIT $from_num, $how_many_records_to_display;");
		$template["videos"] = array();
		foreach ($videos as $video):
			$w++;
			$template["videos"][$w]["feature"] = 0;

			if ($video->video_id && (0 != $video->video_id)) {
				$vid = get_post($video->video_id);
				$template["videos"][$w]["file"] = $vid->guid;
				$image = '';
				$template["videos"][$w]["provider"] = 'video';
				if ($video->video_image_id) {
					$img = get_post($video->video_image_id);
					$template["videos"][$w]["image"] = $img->guid;
				}
			}
			if ($video->video_youtube_id) {
				$template["videos"][$w]["file"] = 'http://www.youtube.com/watch?v='.$video->video_youtube_id;
				$template["videos"][$w]["image"] = 'http://img.youtube.com/vi/'.$video->video_youtube_id.'/0.jpg';
				$template["videos"][$w]["provider"] = 'youtube';
			}
			$template["videos"][$w]["the_date"] = @q8_translate(date("F j, Y",strtotime($video->video_date)),date("j M  Y",strtotime($video->video_date)));
			$template["videos"][$w]["caption"] = esc_attr(@q8_translate($video->video_caption_en,$video->video_caption_fr));
			$template["videos"][$w]["feature"] = ($feature_id == $video->id);
			if ($feature_id != $video->id){
				$playlist[] = '{ "provider": "'.$template["videos"][$w]["provider"].'", "title": "'.$template["videos"][$w]["caption"].'", "file": "'.$template["videos"][$w]["file"].'", "image": "'.$template["videos"][$w]["image"].'" },';
				$x++;
			}
		endforeach;
		$template["feature_video"] = !is_null( $feature_video );
		$template["playlist"] = implode( chr( 13 ), $playlist );
		$template["MPWEB_TEMPLATE_DIR"] = MPWEB_TEMPLATE_DIR;
		$template["ASSET_URL"] = ASSET_URL;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			return $twig->render(CHILD_THEME_PREFIX.'.section.videogallery.twig.html',$template);
		}
	}
	/*
	 *	@func 		get_photo_gallery
	 * 	@desc 		prepares all need variables into a template array. Template is defined in child theme.
	 */
	public function get_photo_gallery( ) 
	{
		global $wpdb, $q_confi;
		$template = array( );
		$js = NULL;
		$url = get_permalink();
		$pg = (strpos($url, '=')) ? "&stranica=": "?stranica=";
		$wpdb->cpc_photo_gallery = $wpdb->prefix . 'cpc_photo_gallery';
		$wpdb->cpc_photo_gallery_id = $wpdb->prefix . 'cpc_photo_gallery_id';
		$r = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery_id WHERE visible = 1 ORDER BY gallery_date DESC;");
		$total_records = $wpdb->num_rows;
		$how_many_records_to_display = 10;
		if (isset($_REQUEST["stranica"])) {
			$from_num = ($_REQUEST["stranica"] * $how_many_records_to_display) - $how_many_records_to_display;
			$to_num = ($_REQUEST["stranica"] * $how_many_records_to_display);
			if (is_numeric($_REQUEST["stranica"])) {
				$prev_page = (0 >= ($_REQUEST["stranica"] - 1)) ? 1 : ($_REQUEST["stranica"] - 1);
				$next_page = $_REQUEST["stranica"] + 1;
			}
		}
		else {
			$next_page = 2;
			$from_num = 0;
			$to_num = $how_many_records_to_display;
		}
		$pages = ceil($total_records / $how_many_records_to_display);
		$prev_page = ((1 == $pages) || (1==$_REQUEST["stranica"]) || (!isset($_REQUEST["stranica"]))) ? NULL : '<li class="previous"><a href="'.$url.$pg.$prev_page.'">&larr; '.@q8_translate("Newer Photos","Articles plus récents").'</a></li>';
		$next_page = (($next_page > $pages) || (1 == $pages))  ? NULL : '<li class="next"><a href="'.$url.$pg.$next_page.'">'.@q8_translate("Older Photos"," Articles plus vieux").' &rarr;</a></li>';
		$template["pagination"] = '<div class="clr"></div><ul class="pager"> '.$prev_page.$next_page.'</ul>';
		$records = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery_id WHERE visible = 1 ORDER BY gallery_date DESC LIMIT $from_num, $how_many_records_to_display;");
		if ($records) :
			$setting = get_option(@$this->theme_mp_photo_gallery_config);
			$size = ($setting["image_size"]) ? $setting["image_size"] : 'large';
			$x=$w=0;
			foreach ($records as $record):
				$x++;
				$photos = $wpdb->get_results("SELECT * FROM $wpdb->cpc_photo_gallery WHERE gallery_id = ".$record->id." ORDER BY id ASC;");
				$y=0;
				$template["galleries"][$w]["the_date"]    = @q8_translate(date("F j, Y",strtotime($record->gallery_date)),date("j M  Y",strtotime($record->gallery_date)));
				$template["galleries"][$w]["name"]        = @q8_translate( $record->gallery_name_en, $record->gallery_name_fr );
				$template["galleries"][$w]["description"] = @q8_translate( $record->gallery_description_en, $record->gallery_description_fr );
				foreach ($photos as $photo):
					$image = wp_get_attachment_image_src($photo->image_id,$size);
					if ($image) {
						$info = get_post($photo->image_id);
						$template["galleries"][$w]["images"][$y]["thumbnail"] = ($record->gallery_thumbnail == $photo->image_id);
						$template["galleries"][$w]["images"][$y]["src"]       = $image[0];
						$template["galleries"][$w]["images"][$y]["title"]     = esc_attr($info->post_title);
					}
					$y++;
				endforeach;
				$w++;
			endforeach;
		endif;

		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			return $twig->render(CHILD_THEME_PREFIX.'.section.photogallery.twig.html',$template);
		}

	}
	public function get_splash_page() 
	{
		$template = array( );
		$template["settings"] = get_option($this->theme_mp_splash_page);
		$template["riding_id"] = get_option("cpc_riding_id");
		$template["title"] = $template["settings"][@q8_translate('title_en','title_fr')];
		$template["caption"] = $template["settings"][@q8_translate('caption_en','caption_fr')];
		$template["blog_name"] = get_bloginfo("name");
		$template["blog_description"] = get_bloginfo("description");
		$theme_settings = get_option($this->theme_mp_splash_page_theme_settings);
		$admin_settings = get_option($this->theme_mp_splash_page_settings);
		$template["position"] = $theme_settings["alignment"];
		if($template["settings"]['youtube_id_en'] || ($template["settings"]['video_id_en'] || (0 != $template["settings"]['video_id_en']))) {
			if($template["settings"]['youtube_id_en']){
				$template["media"]["src"] = "http://www.youtube.com/watch?v={$template['settings']['youtube_id_en']}";
				$template["media"]["image"] = 'http://img.youtube.com/vi/'.$template["settings"]['youtube_id_en'].'/0.jpg';
			} else { 
				$vid = get_post($template["settings"]['video_id_en']);
				$template["media"]["src"] = $vid->guid;
				$template["media"]["image"] = '';
				if ($template["settings"]['video_image_id_en']) {
					$img = get_post($template["settings"]['video_image_id_en']);
					$template["media"]["image"] = $img->guid;
					$template["media"]["preview_image"] = ', "image": "'.$image.'"';
				}
			}
		}
		$template["media"]["has_video"]          = ($template["settings"]['youtube_id_en'] || ($template["settings"]['video_id_en'] || (0 != $template["settings"]['video_id_en'])));
		$template["MPWEB_TEMPLATE_DIR_IMAGES"]   = MPWEB_TEMPLATE_DIR_IMAGES;
		$template["MPWEB_TEMPLATE_DIR"]          = MPWEB_TEMPLATE_DIR;
		$template["form"]["name"]                = @q8_translate("Name *","Nom *");
		$template["form"]["email"]               = @q8_translate("E-mail *","Courriel *");
		$template["form"]["postal_code"]         = @q8_translate("Postal Code *","Code Postal *");
		$template["form"]["button_text"]         = @q8_translate("Sign me up!","Ouvrir session");
		$template["form"]["button_text_loading"] = @q8_translate("Processing...","Traitement...");
		$template["continue_to"]                 = @q8_translate("Continue to the website.","Aller sur le site Internet ");
		$template["socnets"]                     = $this->get_splash_socnets();
		$template["ASSET_URL"]                   = ASSET_URL;
		$template['firstname']					= get_option( 'mpwp_sitename_firstname' );
		$template['lastname']					= get_option( 'mpwp_sitename_lastname' );
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.section.splash.twig.html',$template);
		}
	}
	public function feature_inner_custom_box( ) 
	{
		global $post, $wpdb;
		wp_nonce_field('feature_action', 'feature_noncename');
		if(class_exists('Q8_BLOCK')):
			$block = new Q8_BLOCK();
			$block->add_tab('feature_details',__('Details'),array(&$this,'feature_details'));
			$block->add_tab('feature_image',__('Image'),array(&$this,'feature_image'));
			$block->add_tab('feature_options',__('Options'),array(&$this,'feature_options'));
			$block->draw_block('Feature Article Options','','');
		else:
			echo '<div id="message" class="updated">Please install Q8 Core</div>';
		endif;
	}
	public function feature_details(  ) 
	{
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["title"]             = get_post_meta($_REQUEST["post"], 'cpc_feature_title_'.$lang,true);
			$template["field"][$lang]["excerpt"]           = get_post_meta($_REQUEST["post"], 'cpc_feature_excerpt_'.$lang,true);
			$template["field"][$lang]["link"]              = get_post_meta($_REQUEST["post"], 'cpc_feature_link_'.$lang,true);
			$template["field"][$lang]["title_excerpt_off"] = get_post_meta($_REQUEST["post"], 'cpc_feature_title_excerpt_off_'.$lang,true);			
		endforeach;
		$template["child"] = CHILD_THEME_PREFIX;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.feature_details.twig.html',$template);
	}
	public function feature_image(  ) 
	{
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["image"] = get_post_meta($_REQUEST["post"], 'cpc_feature_image_'.$lang, true);
		endforeach;

		$template["MPWEB_HOME"] = MPWEB_HOME;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.feature_image.twig.html',$template);
	}
	
	public function feature_options(  ) 
	{
		global $wpdb;
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["read_more_text"] = get_post_meta($_REQUEST["post"], 'cpc_feature_read_more_text_'.$lang,true);
		endforeach;
		$template["field"]["image_position"] = get_post_meta($_REQUEST["post"], 'cpc_feature_image_position',true);
		$data = $wpdb->get_row("SELECT menu_order FROM $wpdb->posts WHERE ID = ".$_REQUEST["post"].";");
		$cpc_feature_order = $data->menu_order;
		$template["feature_orders"] = NULL;
		for ($x=1;$x<=3;$x++) :
			$selected = ($cpc_feature_order == $x) ? 'selected="selected"' : NULL;
			$template["feature_orders"] .= '<option value="'.$x.'" '.$selected.'>'.$x.'</option>'.chr(13);
		endfor;
		$template["child"] = CHILD_THEME_PREFIX;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.feature_options.twig.html',$template);
	}
	public function feature_save_postdata( $post_id ) 
	{
		global $wpdb;
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
		if (!wp_verify_nonce( $_POST['feature_noncename'], 'feature_action')) return;
		if ('page' == $_POST['post_type']) { if (!current_user_can('edit_page', $post_id)) return; }
		else { if (!current_user_can( 'edit_post', $post_id)) return; }
		
		$langs = (q8_french_enabled()) ? array('en','fr') : array('en');
		foreach($langs as $lang):
			@q8_save_postdata($post_id, 'cpc_feature_title_'.$lang, $_POST['cpc_feature_title_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_feature_excerpt_'.$lang, $_POST['cpc_feature_excerpt_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_feature_link_'.$lang, $_POST['cpc_feature_link_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_feature_title_excerpt_off_'.$lang, $_POST['cpc_feature_title_excerpt_off_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_feature_image_'.$lang, $_POST['cpc_feature_image_'.$lang]);
			@q8_save_postdata($post_id, 'cpc_feature_read_more_text_'.$lang, $_POST['cpc_feature_read_more_text_'.$lang]);
		endforeach;
		$cpc_feature_order = (0 == $_POST['cpc_feature_order']) ? 1 : $_POST['cpc_feature_order'];
		$cpc_feature_image_position = $_POST['cpc_feature_image_position']; @q8_save_postdata($post_id, 'cpc_feature_image_position', $cpc_feature_image_position);
		foreach ($_POST["post_category"] as $cat):
			$cat_data = get_category($cat);
			if ($this->categories["feature-article"] == $cat_data->slug) {
				$this_is_a_feature = true;
			}
		endforeach;
		$data = ($this_is_a_feature) ? $wpdb->update( $wpdb->posts, array( 'menu_order' => $cpc_feature_order ), array( 'ID' => $post_id ), array( '%d' ), array( '%d' ) ) : NULL;
	}
	public function subfeature_inner_custom_box() 
	{
		$template = array( );
		$template["langs"] = (q8_french_enabled())? array('en','fr') : array('en');
		foreach($template["langs"] as $lang):
			$template["field"][$lang]["title"]   = get_post_meta($_REQUEST["post"], 'cpc_subfeature_title_'.$lang,true);
			$template["field"][$lang]["excerpt"] = get_post_meta($_REQUEST["post"], 'cpc_subfeature_excerpt_'.$lang,true);
			$template["field"][$lang]["image"]   = get_post_meta($_REQUEST["post"], 'cpc_subfeature_image_'.$lang,true);
		endforeach;
		wp_nonce_field('subfeature_action', 'subfeature_noncename');
		$template["MPWEB_HOME"] = MPWEB_HOME;
		$twig = q8_new_twig_engine(MPWEB_TEMPLATE_DIR_TEMPLATES);
		echo $twig->render('mpwp.metabox.subfeature.twig.html',$template);
	}
	/* WordPress Frontend Functions */
	public function get_feature( ) 
	{
		global $post;
		$template = array( );
		$args = array('category_name'=>'feature-article','posts_per_page'=>5,'orderby'=>'date','order'=>'DESC');
		$query = new WP_Query($args);
		$read_more = ( 'mandatory' == CHILD_THEME_PREFIX ) ? @q8_translate( 'Full Article', 'Article intégral' ) : @q8_translate( 'Read More', 'Suite' );
		if ($query->have_posts()):
			$x=0;
			while ($query->have_posts()) : $query->the_post();
				$custom_feature_title          = get_post_meta($query->post->ID,@q8_translate('cpc_feature_title_en','cpc_feature_title_fr'),true);
				$custom_feature_excerpt        = get_post_meta($query->post->ID,@q8_translate('cpc_feature_excerpt_en','cpc_feature_excerpt_fr'),true);
				$custom_feature_link           = get_post_meta($query->post->ID,@q8_translate('cpc_feature_link_en','cpc_feature_link_fr'),true);
				$custom_feature_read_more_text = get_post_meta($query->post->ID,@q8_translate('cpc_feature_read_more_text_en','cpc_feature_read_more_text_fr'),true);
				
				$template["features"][$x]["title_excerpt_off"] = get_post_meta($query->post->ID,@q8_translate('cpc_feature_title_excerpt_off_en','cpc_feature_title_excerpt_off_fr'),true);
				$template["features"][$x]["image"]             = get_post_meta($query->post->ID,@q8_translate('cpc_feature_image_en','cpc_feature_image_fr'),true);
				$template["features"][$x]["title"]             = ($custom_feature_title) ? $custom_feature_title : get_the_title();
				$template["features"][$x]["excerpt"]           = ($custom_feature_excerpt) ? $custom_feature_excerpt : get_the_excerpt();
				$template["features"][$x]["read_more_text"]    = ($custom_feature_read_more_text) ? $custom_feature_read_more_text : $read_more;
				$template["features"][$x]["link"]              = ($custom_feature_link) ? $custom_feature_link : get_permalink();
				$template["features"][$x]["position"]          = get_post_meta($query->post->ID,'cpc_feature_image_position',true);
				$template["features"][$x]["has_image"]         = ($template["features"][$x]["image"]);
				$x++;
			endwhile;
		endif; wp_reset_postdata();
		$template["ASSET_URL"] = ASSET_URL.CHILD_THEME_PREFIX;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			return $twig->render(CHILD_THEME_PREFIX.'.section.feature.twig.html',$template);
		}
	}
	public function get_subfeature( $limit = 10 ) 
	{
		global $post;
		$template = array( );
		$read_more = ( 'mandatory' == CHILD_THEME_PREFIX ) ? @q8_translate( 'Full Article', 'Article intégral' ) : @q8_translate( 'Read More', 'Suite' );
		$template["read_more"] = $read_more;
		$i=$x=0;
		$args = array('category_name'=>'subfeature','posts_per_page'=>$limit,'orderby'=>'date','order'=>'DESC');
		$query = new WP_Query($args);
		if ($query->have_posts()) :  
			$template["subfeatures"] = array( );
			while ($query->have_posts()): $query->the_post(); 
				$i++;
				$custom_subfeature_title   = get_post_meta($query->post->ID,@q8_translate('cpc_subfeature_title_en','cpc_subfeature_title_fr'),true);
				$custom_subfeature_excerpt = get_post_meta($query->post->ID,@q8_translate('cpc_subfeature_excerpt_en','cpc_subfeature_excerpt_fr'),true);
				$template["subfeatures"][$x]["position"] = (1 == $i)? 'left' : 'right';
				$template["subfeatures"][$x]["title"]    = ($custom_subfeature_title) ? $custom_subfeature_title : get_the_title();
				$template["subfeatures"][$x]["excerpt"]  = ($custom_subfeature_excerpt) ? $custom_subfeature_excerpt : get_the_excerpt();
				$template["subfeatures"][$x]["the_date"] = $date = get_the_date( );
				$template["subfeatures"][$x]["link"]     = get_permalink();
				$template["subfeatures"][$x]["src"]      = get_post_meta($query->post->ID, @q8_translate('cpc_subfeature_image_en','cpc_subfeature_image_fr'),true);;
				if (2 == $i) { $i=0; }
				$x++;
	        endwhile; 
        endif; wp_reset_postdata();

        if( $query->have_posts() ):
			if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
				$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
				return $twig->render(CHILD_THEME_PREFIX.'.section.subfeature.twig.html',$template);
			}
		endif;
	}
	public function get_hot_topics( ) 
	{
		$template = array( );
		$setting = get_option(@$this->theme_mp_hot_topics);
		if (1 == $setting['visible']) {
			$button = @q8_translate('button_en','button_fr');
			$cat = $setting['categories'];
			if ($cat) {
				$template["button_text"] = ($setting[$button]) ? $setting[$button] : @q8_translate('Read More','Suite');
				$template["heading"]   = @q8_translate('Hot Topic','Sujets de l’heure');
				$args = array('cat'=>$cat,'posts_per_page'=>1,'orderby'=>'date','order'=>'DESC');
				$query = new WP_Query($args);
				while ($query->have_posts()) : $query->the_post();
					$template["title"] = get_the_title();
					$template["excerpt"] = get_the_excerpt();
					$template["link"] = get_permalink();
				endwhile; wp_reset_postdata();
			}
			if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
				$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
				return $twig->render(CHILD_THEME_PREFIX.'.section.hottopics.twig.html',$template);
			}
		}
	}
	public function get_news( ) 
	{
		global $post;
		$template = array( );
		$cat = @$this->categories["homepage"];
		$read_more = ( 'mandatory' == CHILD_THEME_PREFIX ) ? @q8_translate( 'Full Article', 'Article intégral' ) : @q8_translate( 'Read More', 'Suite' );
		$template["read_more"] = $read_more;
		$section = '<section id="maincol" class="grid_8">';
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$args = array('category_name'=>'homepage','orderby'=>'date','order'=>'DESC','paged'=>$paged);
		$query = new WP_Query($args);
		$x=0;
		while ($query->have_posts()) : $query->the_post();
			$template["posts"][$x]["title"]   = get_the_title();
			$template["posts"][$x]["date"]    = get_the_date( );
			$template["posts"][$x]["link"]    = get_permalink();
			$template["posts"][$x]["excerpt"] = get_the_excerpt();
			$template["posts"][$x]["image"]   = @$this->get_news_image($query->post->ID);
			foreach(get_the_category($query->post->ID) as $cat):
				if( $cat->slug == $this->categories["events"] )
				{
					$template["posts"][$x]["event"]["date"]     	= strtotime(get_post_meta($query->post->ID, 'cpc_event_date', true));
					$template["posts"][$x]["event"]["time"]     	= strtotime(get_post_meta($query->post->ID, 'cpc_event_time', true));
					$template["posts"][$x]["event"]["location"] 	= get_post_meta($query->post->ID, @q8_translate('cpc_event_location_en','cpc_event_location_fr'), true);
					$template["posts"][$x]["event"]["map"]      	= get_post_meta($query->post->ID, 'cpc_event_location_map', true);
					$cpc_event_location_map_embed					= get_post_meta($query->post->ID, 'cpc_event_location_map_embed', true);
					$template["posts"][$x]["event"]["map_embed"]	= preg_replace( '/width="[a-zA-Z0-9]*"/', 'width="100%"', $cpc_event_location_map_embed );
				}
				if($cat->slug == $this->categories["media-release"]) {
					$template["posts"][$x]["media"]["source"] = get_post_meta($query->post->ID, 'cpc_media_source', true);
					$template["posts"][$x]["media"]["author"] = get_post_meta($query->post->ID, 'cpc_media_author', true);
					$template["posts"][$x]["media"]["date"]   = get_post_meta($query->post->ID, 'cpc_media_publish_date', true);
					$template["posts"][$x]["media"]["link"]   = get_post_meta($query->post->ID, 'cpc_media_link', true);
				}
			endforeach;
			$x++;
		endwhile; wp_reset_postdata();

		$template["pagination"] = '
        <ul class="pager"> 
            <li class="previous">'.get_next_posts_link( '&larr; '.@q8_translate("Older Articles"," Articles plus vieux"), $query->max_num_pages).'</li>
            <li class="next">'.get_previous_posts_link( @q8_translate("Newer Articles","Articles plus récents").' &rarr;', $query->max_num_pages).'</li>  
        </ul>';
        $template["MPWP"] = $this;
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);

			$template["rss_news_feed"] = " ";
			if ( class_exists( "Q8_NewsFeed" ) ):
				global $Q8_NewsFeed;
				$template["rss_news_feed"] = $Q8_NewsFeed->the_top_news( CHILD_THEME_PREFIX );
			endif;

			echo $twig->render(CHILD_THEME_PREFIX.'.section.news.twig.html',$template);
		}
	}
	public function get_socialtools( $link, $readmore=false ) 
	{
		$template = array( );
		$template["setting"]  = get_option(@$this->theme_mp_social_tools);
		$read_more = ( 'mandatory' == CHILD_THEME_PREFIX ) ? @q8_translate( 'Full Article', 'Article intégral' ) : @q8_translate( 'Read More', 'Suite' );
		$template["readmore"] = ($readmore) ? $read_more : NULL;
		$template["link"]     = $link;
        if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
        	$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
        	echo $twig->render(CHILD_THEME_PREFIX.'.section.socialtools.twig.html',$template);
        }
	}

	/*
	 *	@func 	the_excerpt
	 * 	@params excerpt, character length
	 * 	@desc 	Takes the excerpt and trims it to the character length you pass. Perserves words.  
	 */	
	public function the_excerpt($excerpt,$charlength) 
	{
		$charlength++;
		$excerpt = trim($excerpt);
		if (strlen($excerpt) > $charlength) {
			$subex = substr($excerpt, 0, $charlength - 5);
			$exwords = explode(' ', $subex);
			$excut = - ( strlen( $exwords[ count($exwords) - 1 ]));
			if ($excut < 0) { $excerpt = substr($subex, 0, $excut); } else { $excerpt = $subex; } $excerpt .=  '...';
		}
		return $excerpt;
	}
	public function get_headshot() 
	{
		$setting = get_option('cpc_riding_id');
		$headshot = ($setting) ? '<img class="mp" src="' . ASSET_URL.CHILD_THEME_PREFIX . "/" . $setting . '.png" />' : NULL;//_headshot
		return $headshot;
	}
	public function get_banner() 
	{
		$image_extension = ( 'mandatory' == CHILD_THEME_PREFIX ) ? '.jpg' : '.png';
		$template                              = array( );
		$template["setting"]                   = get_option(@$this->theme_mp_banner);
		$template["setting2"]                  = get_option(@$this->theme_mp_bannerbg);
		$template["img"]                       = $template["setting2"]['banner_backdrop'];
		$template["img_tablet"]                = str_replace( $image_extension, "_tablet" . $image_extension,$template["img"]);
		$template["blogname"]                  = get_option("blogname");
		$template["blogdescription"]           = get_option("blogdescription");
		$template["riding_id"]                 = get_option("cpc_riding_id");
		$template["MPWEB_TEMPLATE_DIR_IMAGES"] = MPWEB_TEMPLATE_DIR_IMAGES;
		$template["MPWEB_HOME"]                = MPWEB_HOME;
		$template["CHILD_TEMPLATE_DIR_IMAGES"] = CHILD_TEMPLATE_DIR_IMAGES;
		$template["ASSET_URL"]                 = ASSET_URL.CHILD_THEME_PREFIX;

		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			return $twig->render(CHILD_THEME_PREFIX.'.section.banner.twig.html',$template);
		}
	}
	public function get_footer_links() 
	{
		global $post;
		$args = array('post_type'=>'page','posts_per_page'=>4,'meta_query'=>array('relation'=>'OR',array('key'=>'cpc_privacy_policy','value'=>'1'),array('key'=>'cpc_contact','value'=>'1')),'orderby'=>'title','order'=>'ASC');
		$query = new WP_Query($args);
		$x=0;
		while ($query->have_posts()) : $query->the_post(); $x++;
			$vr = (1 == $x) ? "&nbsp;|&nbsp;" : NULL;
			$links .= '<a href="'.get_permalink().'">'.get_the_title().'</a>'.$vr;
		endwhile; wp_reset_postdata();
		$links = ( 1 == $x ) ? str_replace( "&nbsp;|&nbsp;", '', $links ) : $links;
		if ( 'mandatory' == CHILD_THEME_PREFIX )
		{
			$links = '<div class="footer_links">
			<span class="footer_mp_name"><a href="' . home_url( ) .'">' . @q8_translate( 'Leader of the Opposition - ' ,'' ) . get_bloginfo( 'name' ) .'</a></span>
			<span class="pull-right">'.$links.'</span>
			</div>';
		}
		else
		{
			$links = '<hr /><div class="footer_links">'.$links.'</div>';
		}
		return $links;
	}
	public function get_sitemap( ) 
	{
		global $wpdb,$post; 
		$setting = get_option(@$this->theme_mp_footer_menu);
		$template = array( );
		$current_pg = $post->ID;
		$custom_menu_name = @q8_translate('cpc_menu_item_name_en','cpc_menu_item_name_fr');
		$args = array('post_type'=>'page','posts_per_page'=>7,'meta_query'=>array(array('key'=>'cpc_menu_item','value'=>1)),'orderby'=>'menu_order','order'=>'ASC');
		$query = new WP_Query($args);
		$x=0;
		while ($query->have_posts()) : $query->the_post();
			$sub_menu_items = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_parent = {$query->post->ID} AND post_status = 'publish' AND post_type = 'page' ORDER BY menu_order ASC;");
			$link = get_post_meta($query->post->ID,'cpc_menu_item_link',true);
			$menu_title = get_post_meta($query->post->ID,$custom_menu_name,true);
			$template["menu_items"][$x]["link"] = ($link) ? $link : get_permalink();
			$template["menu_items"][$x]["title"] = ($menu_title) ? $menu_title : get_the_title($post->ID);
			$template["menu_items"][$x]["is_external"] = ($link)? 1 : 0;
			$template["menu_items"][$x]["has_submenu"] = (!empty($sub_menu_items))? 1 : 0;
			if ($sub_menu_items) {
				$y=0;
				foreach ($sub_menu_items as $sub_menu_item):	
					$link = get_post_meta($sub_menu_item->ID,'cpc_menu_item_link',true);
					$menu_title = get_post_meta($sub_menu_item->ID,$custom_menu_name,true);
					$template["menu_items"][$x]["submenu_items"][$y]["link"] = ($link) ? $link : get_permalink($sub_menu_item->ID);
					$template["menu_items"][$x]["submenu_items"][$y]["title"] = ($menu_title) ? $menu_title : get_the_title($sub_menu_item->ID);
					$template["menu_items"][$x]["submenu_items"][$y]["is_external"] = ($link);
					$y++;
				endforeach;
			}
			$x++;
		endwhile; wp_reset_postdata();
		if(1 == (int)$setting["footer_menu"]){
			if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
				$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
				return $twig->render(CHILD_THEME_PREFIX.'.section.sitemap.twig.html',$template);
			}
		}
	}
	public function get_menu( ) 
	{
		global $wpdb,$post; 
		$template = array( );
		$current_pg = $post->ID;
		$toggle = @q8_translate("Fr","En");
		$custom_menu_name = @q8_translate('cpc_menu_item_name_en','cpc_menu_item_name_fr');
		$template["home"]["link"] = ( @q8_french_enabled( ) ) ? qtrans_convertURL( MPWEB_HOME, strtolower( @q8_translate("en","fr") ) ) : MPWEB_HOME;
		$template["home"]["title"] = @q8_translate('Home','Accueil');
		$args = array('post_type'=>'page','posts_per_page'=>7,'meta_query'=>array(array('key'=>'cpc_menu_item','value'=>1)),'orderby'=>'menu_order','order'=>'ASC');
		$query = new WP_Query($args);
		$x=0;
		while ($query->have_posts()) : $query->the_post();
			$sub_menu_items = $wpdb->get_results("SELECT * FROM $wpdb->posts WHERE post_parent = {$query->post->ID} AND post_status = 'publish' AND post_type = 'page' ORDER BY menu_order ASC;");
			$link = get_post_meta($query->post->ID,'cpc_menu_item_link',true);
			$menu_title = get_post_meta($query->post->ID,$custom_menu_name,true);
			$template["menu_items"][$x]["link"] = ($link) ? $link : get_permalink();
			$template["menu_items"][$x]["title"] = ($menu_title) ? $menu_title : get_the_title($post->ID);
			$template["menu_items"][$x]["is_external"] = ($link)? 1 : 0;
			$template["menu_items"][$x]["is_active"] = ($query->post->ID == $current_pg)? 1 : 0;
			$template["menu_items"][$x]["has_submenu"] = (!empty($sub_menu_items))? 1 : 0;
			if ($sub_menu_items) {
				$y=0;
				foreach ($sub_menu_items as $sub_menu_item):	
					$link = get_post_meta($sub_menu_item->ID,'cpc_menu_item_link',true);
					$menu_title = get_post_meta($sub_menu_item->ID,$custom_menu_name,true);
					$template["menu_items"][$x]["submenu_items"][$y]["link"] = ($link) ? $link : get_permalink($sub_menu_item->ID);
					$template["menu_items"][$x]["submenu_items"][$y]["title"] = ($menu_title) ? $menu_title : get_the_title($sub_menu_item->ID);
					$template["menu_items"][$x]["submenu_items"][$y]["is_external"] = ($link);
					$template["menu_items"][$x]["submenu_items"][$y]["is_active"] = ($sub_menu_item->ID == $current_pg);
					$y++;
				endforeach;
			}
			$x++;
		endwhile; wp_reset_postdata();
		if (@q8_french_enabled()) {
			$template["french_enabled"]["title"] = @q8_translate("Français","English");
			$l = @q8_translate("fr","en");
			//$template["french_enabled"]["link"] = (is_front_page()) ? MPWEB_HOME."/?lang=".$l : get_permalink($current_pg)."&lang=".$l;
			$template["french_enabled"]["link"] = (is_front_page()) ? qtrans_convertURL( MPWEB_HOME, @q8_translate( 'fr', 'en' ) ) : qtrans_convertURL( get_permalink($current_pg), @q8_translate( 'fr', 'en' ) );
		}
		$template["blogname"] = get_option("blogname");
		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			return $twig->render(CHILD_THEME_PREFIX.'.section.mainmenu.twig.html',$template);
		}
	}
	public function contact_form( ) 
	{
		global $wpdb;
		$template = array( );
		$lang = q8_translate("en","fr");
		$setting = get_option(@$this->theme_mp_contact_form);
		$message_success = $setting["success_message_$lang"];
		$message_error = $setting["error_message_$lang"];
		$template["hidden_name"]                       = md5("contact_form");
		$template["hidden_value"]                      = md5(date("His"));

		$template["field"]["firstname"]["name"]        = md5('contact_name');
		$template["field"]["firstname"]["placeholder"] = $setting["name_text_$lang"].' *';
		$template["field"]["firstname"]["class"]       = "name";

		$template["field"]["email"]["name"]            = md5('contact_email');
		$template["field"]["email"]["placeholder"]     = $setting["email_text_$lang"].' *';
		$template["field"]["email"]["class"]           = 'email';

		$template["field"]["st_address"]["name"]          = md5('contact_st_address');  //Added March 2, 2018
		$template["field"]["st_address"]["placeholder"]   = @q8_translate("Street Address *","Adresse de rue *");  //Added March 2, 2018
		$template["field"]["st_address"]["class"]         = 'st_address'; //Added March 2, 2018

		$template["field"]["city_town"]["name"]          = md5('contact_city_town');  //Added Dec 18, 2017
		$template["field"]["city_town"]["placeholder"]   = @q8_translate("City/Town *","Ville *");  //Added Dec 18, 2017
		$template["field"]["city_town"]["class"]         = 'city_town'; //Added Dec 18, 2017


		$template["field"]["subject"]["name"]          = md5('contact_subject');  //Added Dec 18, 2017
		$template["field"]["subject"]["placeholder"]   = @q8_translate("Subject *","Sujet *");  //Added Dec 18, 2017
		$template["field"]["subject"]["class"]         = 'subject'; //Added Dec 18, 2017

		$template["field"]["province"]["name"]          = md5('contact_province');  //Added Jan 26, 2018
		$template["field"]["province"]["placeholder"]   = @q8_translate("Province *","Province *");  //Added Jan 26, 2018
		$template["field"]["province"]["class"]         = 'province'; //Added Jan 26, 2018

		$template["field"]["message"]["name"]          = md5('contact_message');
		$template["field"]["message"]["placeholder"]   = $setting["message_text_$lang"].' *';
		$template["field"]["message"]["class"]         = 'message';

		$field_value_name = $field_value_email = $field_value_message = $field_value_postalcode = $field_value_phonenumber = NULL;
		if ("1.1" == $setting["tbl_version"]) {
			$template["field"]["postal_code"]["name"]         = md5('contact_postalcode');
			$template["field"]["postal_code"]["placeholder"]  = $setting["postalcode_text_$lang"].' *';
			$template["field"]["postal_code"]["class"]        = 'postalcode';

			$template["field"]["phone_number"]["name"]        = md5('contact_phonenumber');
			$template["field"]["phone_number"]["placeholder"] = $setting["phonenumber_text_$lang"].' *';
			$template["field"]["phone_number"]["class"]       = 'phonenumber';
		}
		if (isset($_POST[$template["hidden_name"]])) {
			$valid_postalcode = false;
			$field_value_name = $template["field"]["firstname"]["value"] = @q8_clean_post($_POST[$template["field"]["firstname"]["name"]]);
			$field_value_email = $template["field"]["email"]["value"] = @q8_clean_post($_POST[$template["field"]["email"]["name"]]);
			$field_value_message = $template["field"]["message"]["value"] = @q8_clean_post($_POST[$template["field"]["message"]["name"]]);
			$field_value_subject = $template["field"]["subject"]["value"] = @q8_clean_post($_POST[$template["field"]["subject"]["name"]]); //Added Dec 18, 2017
			$field_value_st_address = $template["field"]["st_address"]["value"] = @q8_clean_post($_POST[$template["field"]["st_address"]["name"]]); //Added Dec 18, 2017
			$field_value_city_town = $template["field"]["city_town"]["value"] = @q8_clean_post($_POST[$template["field"]["city_town"]["name"]]); //Added Jan 26, 2018
			$field_value_province = $template["field"]["province"]["value"] = @q8_clean_post($_POST[$template["field"]["province"]["name"]]); //Added Jan 26, 2018
			$template["field"]["firstname"]["class"] = ($field_value_name) ? "name" : "name input-error";
			$template["field"]["email"]["class"]     = (is_email($field_value_email)) ? "email" : "email input-error";
			$template["field"]["message"]["class"]   = ($field_value_message) ? NULL : "input-error";
			$ip = $_SERVER['REMOTE_ADDR'];
			$wpdb->cpc_contact = $wpdb->prefix . 'cpc_contact';
			if ("1.1" == $setting["tbl_version"]) {
				$field_value_postalcode = $template["field"]["postal_code"]["value"] = @q8_clean_post($_POST[$template["field"]["postal_code"]["name"]]);
				$field_value_phonenumber = $template["field"]["phone_number"]["value"] = @q8_clean_post($_POST[$template["field"]["phone_number"]["name"]]);
				$template["field"]["phone_number"]["class"] = ($field_value_phonenumber)? "phonenumber" : "phonenumber input-error";
				if ($field_value_postalcode) {
					$valid_postalcode = preg_match('/^[a-zA-Z][0-9][a-zA-Z][[:space:]]*[0-9][a-zA-Z][0-9]$/', $field_value_postalcode);
				}
				$template["field"]["postal_code"]["class"] = ($valid_postalcode) ? "postalcode" : "postalcode input-error";
			}
			
			if ($field_value_name && is_email($field_value_email) && $field_value_message && $valid_postalcode && $field_value_phonenumber && $field_value_subject && $field_value_st_address) { //Added Dec 19, 2017
				$field_value_email = strtolower($field_value_email);
				if ($field_value_postalcode && $valid_postalcode) {
					if (7 == strlen($field_value_postalcode)) {
						$field_value_postalcode = substr($field_value_postalcode, 0, 3) . substr($field_value_postalcode, 4, 3);
					}
					$field_value_postalcode = strtoupper($field_value_postalcode);
				}
				if ("1.1" == $setting["tbl_version"]) {
					$new_contact = $wpdb->insert(
						$wpdb->cpc_contact,
						array(
							'name'        => $field_value_name,
							'email'       => $field_value_email,
							'postalcode'  => $field_value_postalcode,
							'phonenumber' => $field_value_phonenumber,
							'message'     => $field_value_message,
							'ip'          => $ip
						),
						array( '%s', '%s', '%s', '%s', '%s', '%s' )
					);
				}
				else {
					$new_contact = $wpdb->insert(
						$wpdb->cpc_contact,
						array(
							'name'    => $field_value_name,
							'email'   => $field_value_email,
							'message' => $field_value_message,
							'ip'      => $ip
						),
						array( '%s', '%s', '%s', '%s' )
					);
				}
				if (1 == $new_contact) {
					$setting2 = get_option(@$this->theme_mp_contact_form_notification);
					if ((1 == (int)$setting2["notify"]) && ("" !== $setting2["to_notify_name"]) && ("" !== $setting2["to_notify_email"])) {
						$send_email = @q8_get_email_addresses($setting2["to_notify_name"],$setting2["to_notify_email"]);
						$headers = @q8_mail_headers($field_value_name,$field_value_email);
						$headers = $send_email["cc"] . $headers;
						$headers = array('Content-Type: text/html; charset=UTF-8', 'From: '.$field_value_name.' <'.$field_value_email.'>' . "\r\n", );
						$email_message = str_replace(chr(13),"<br />",$field_value_message);
						$field_value_postalcode_send = ($field_value_postalcode) ? "<br />Postal Code: $field_value_postalcode" : NULL;
						$field_value_phonenumber_send = ($field_value_phonenumber) ? "<br />Phone Number: $field_value_phonenumber" : NULL;
						$field_value_subject_send= ($field_value_subject) ? "<br />Subject: $field_value_subject" : NULL; // added Dec 19, 2017
						$field_value_st_address_send= ($field_value_st_address) ? "<br />Street Address: $field_value_st_address" : NULL; // added Dec 19, 2017
						$field_value_city_town_send= ($field_value_city_town) ? "<br />City/Town: $field_value_city_town" : NULL; // added March 2, 2018
						$field_value_province_send= ($field_value_province) ? "<br />Province: $field_value_province" : NULL; // added March 2, 2018
						$message ="$email_message<br /><br />$field_value_name<br />$field_value_email"."$field_value_st_address_send"."$field_value_city_town_send"."$field_value_province_send"."$field_value_postalcode_send"."$field_value_phonenumber_send";
						@wp_mail($send_email["to"], "Contact Form - " . $field_value_subject, $message, $headers);
					}
				}
				return '<div class="contactform"><div class="alert alert-success">'.$message_success.'</div></div>';
			}
			else {
				$template["msg"] = '<div class="alert alert-danger">'.$message_error.'</div>';
			}
		}
		$template["required_text"] = ("1.1" == $setting["tbl_version"]) ? @q8_translate('Fields marked with an asterisk (*) are required.','') : @q8_translate('All fields below are required"','');
		$template["tbl_version"] = $setting["tbl_version"];
		$template["button_text"] = @q8_translate('SUBMIT','SOUMETTRE');
        if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
        	$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
        	return $twig->render(CHILD_THEME_PREFIX.'.section.contactform.twig.html',$template);
        }
	}
	public function get_news_image( $id, $size='medium' ) 
	{
		$files = get_children('post_parent='.$id.'&post_type=attachment&post_mime_type=image');
		if($files) :
			$keys = array_reverse(array_keys($files));
			$j=0;
			$num = $keys[$j];
			$image=wp_get_attachment_image($num,$size,false);
			$imagepieces = explode('"', $image);
			$imagepath = $imagepieces[1];
			$thumb=wp_get_attachment_thumb_url($num);
			$temp = $thumb;
		endif;
		return $temp;
	}
	public function emailsignup_widget( $args, $instance ) { $this->emailsignup_form( "", "", "", $args, $instance ); }
	public function emailsignup_form ( $atts, $content, $append = "short", $args = "", $instance = "" ) 
	{
		$template = array( );
		@extract( $args );
		global $wpdb;
		$lang = @q8_translate("en","fr");
		$pa = (parse_url('http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']));
		$param = (!$pa['query']) ? "?" : "&";
		$langurl = (@q8_french_enabled() && isset( $_REQUEST['lang'] )) ? $param."lang=".$_REQUEST["lang"] : NULL;
		$setting = get_option(@$this->theme_mp_email_signup_form);
		$message_success = $setting["success_message_$lang"];
		$message_error = $setting["error_message_$lang"];
		$template["before_widget"]                       = $before_widget;
		$template["after_widget"]                        = $after_widget;
		$template["before_title"]                        = $before_title;
		$template["after_title"]                         = $after_title;
		$template["hidden_name"]                         = md5("email_signup_form_sidebar".$append);
		$template["hidden_value"]                        = md5(date("His").$append);
		$template["field"]["firstname"]["name"]          = md5('email_signup_name');
		$template["field"]["firstname"]["placeholder"]   = $setting["name_text_$lang"];
		$template["field"]["email"]["name"]              = md5('email_signup_email'); //Added Dec 18, 2017
		$template["field"]["email"]["placeholder"]       = $setting["email_text_$lang"]; //Added Dec 18, 2017
		$template["field"]["postal_code"]["name"]        = md5('email_signup_postalcode');//Added Dec 18, 2017
		$template["field"]["postal_code"]["placeholder"] = $setting["postalcode_text_$lang"]; //Added Dec 18, 2017
		$template["field"]["city_town"]["name"]        = md5('email_signup_city_town'); //Added Jan 26, 2018
		$template["field"]["city_town"]["placeholder"] = $setting["city_town_text_$lang"]; //Added Jan 26, 2018
		$template["field"]["province"]["name"]        = md5('email_signup_province'); //Added Jan 26, 2018
		$template["field"]["province"]["placeholder"] = $setting["province_text_$lang"]; //Added Jan 26, 2018			
		$template["button_text"]                         = $setting["submit_text_$lang"];
		$template["title"]                               = $setting["caption_$lang"];
		$template["action"]                              = 'http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'].$langurl.'#mailinglistsidebar'.$append;

		if (isset($_POST[$template["hidden_name"]])) {
			$field_value_name = $template["field"]["firstname"]["value"] = @q8_clean_post($_POST[$template["field"]["firstname"]["name"]]);
			$field_value_subject = $template["field"]["subject"]["value"] = @q8_clean_post($_POST[$template["field"]["subject"]["name"]]); //Added Dec 18, 2017
			$field_value_email = $template["field"]["email"]["value"] = @q8_clean_post($_POST[$template["field"]["email"]["name"] ]);
			$field_value_st_address = $template["field"]["city_town"]["value"] = @q8_clean_post($_POST[$template["field"]["city_town"]["name"] ]);//Added Jan 26, 2018
			$field_value_subject = $template["field"]["province"]["value"] = @q8_clean_post($_POST[$template["field"]["province"]["name"]]); //Added Jan 26, 2018
			$field_value_email = $template["field"]["email"]["value"] = @q8_clean_post($_POST[$template["field"]["email"]["name"] ]);
			$field_value_postalcode = $template["field"]["postal_code"]["value"] = @q8_clean_post($_POST[$template["field"]["postal_code"]["name"]]);
			$valid_postalcode = preg_match('/^[a-zA-Z][0-9][a-zA-Z][[:space:]]*[0-9][a-zA-Z][0-9]$/', $field_value_postalcode);
			$ip = $_SERVER['REMOTE_ADDR'];
			$wpdb->cpc_email_signup = $wpdb->prefix . 'cpc_email_signup';
			if ($field_value_name && is_email($field_value_email) && $valid_postalcode) {
				$field_value_email = strtolower($field_value_email);
				if (7 == strlen($field_value_postalcode)) {
					$field_value_postalcode = substr($field_value_postalcode, 0, 3) . substr($field_value_postalcode, 4, 3);
				}
				$field_value_postalcode = strtoupper($field_value_postalcode);
				$new_email_signup = $wpdb->insert(
					$wpdb->cpc_email_signup,
					array(
						'name'       => $field_value_name,
						'email'      => $field_value_email,
						'postalcode' => $field_value_postalcode,
						'ip'         => $ip
					),
					array( '%s', '%s', '%s', '%s' )
				);
				if (1 == $new_email_signup) {
					$setting2 = get_option(@$this->theme_mp_email_form_notification);
					if ((1 == (int)$setting2["notify"]) && ("" !== $setting2["to_notify_name"]) && ("" !== $setting2["to_notify_email"])) {
						$send_email = @q8_get_email_addresses($setting2["to_notify_name"],$setting2["to_notify_email"]);
						$headers = @q8_mail_headers($field_value_name,$field_value_email);
						$headers = $send_email["cc"] . $headers;
						$message ="<b>".__("Name")."</b>: $field_value_name<br /><b>".__("Email")."</b>: $field_value_email<br /><b>".__("Postal Code")."</b>: $field_value_postalcode<br />";
						@wp_mail($send_email["to"], __("Email Signup Form"), $message, $headers);
					}
				}
				$template["complete"] = 1;
				$template["msg"] = '<div class="alert alert-success">'.$message_success.'</div>';
			}
			else {
				$template["msg"] = '<div class="alert alert-danger">'.$message_error.'</div>';
			}
		}

		if(defined("CHILD_TEMPLATE_DIR_TEMPLATES") && defined("CHILD_THEME_PREFIX")) {
			$twig = q8_new_twig_engine(CHILD_TEMPLATE_DIR_TEMPLATES);
			echo $twig->render(CHILD_THEME_PREFIX.'.widget.emailsignup.twig.html',$template);
		}
	}
	function text_translation( ) { load_theme_textdomain('congratulatory', TEMPLATEPATH.'/languages/'); }

	public function mpwp_update_page( )
	{	
		if ( $_GET["page"] === "mpwp_update" )
			add_theme_page( __("UPDATE"), __("UPDATE"), "edit_pages", "mpwp_update", array( &$this, "mpwp_update" ) );
	}

	public function q8_theme_shortcode( )
	{
		update_option( "q8_theme_shortcode", CHILD_THEME_PREFIX );
	}

	public function q8_admin_notice( )
	{
		?>
		<div class="updated" style="font-size: 1.2em;"><p>
			<a href="plugins.php"><?php echo __("<strong>This theme requires the \"Q8 Core\" Plugin</strong> please click here to install"); ?></a>
		</p></div>
		<?php
	}
	
	public function get_month( $month )
	{
		$month = strtolower( $month );
		$mnths = array(
			'jan' => 'janv',
			'feb' => 'févr',
			'mar' => 'mars',
			'apr' => 'avril',
			'may' => 'mai',
			'june' => 'juin',
			'july' => 'juil',
			'aug' => 'août',
			'sept' => 'sept',
			'oct' => 'oct',
			'nov' => 'nov',
			'dec' => 'déc',
		 );
		 if ( array_key_exists( $month, $mnths ) ):
		 	$month = @q8_translate( $month, $mnths[$month] );
		 endif;
		 return ucfirst( $month );
	}

}
$MPWP = new MPWP();
global $MPWP;
else : exit("Class 'MPWP' already exists"); endif;

/**
 *	WORDPRESS HOOKS
 */
if ( isset( $MPWP ) ):

add_action( "init", array(&$MPWP, 'q8_theme_shortcode') );

if ( defined( "Q8_CORE_ACTIVE_FLAG" ) ):

if ( is_admin( ) ):
add_action('admin_init', array(&$MPWP, 'wp_admin_scripts'));
//add_action('admin_init', array(&$MPWP, 'delete_submenu_items'));
add_action('admin_init', array(&$MPWP, 'downloads'));
add_action('admin_menu', array(&$MPWP, 'admin_menu'));

add_action( "admin_menu", array(&$MPWP, 'mpwp_update_page') );

add_filter('admin_footer_text', array(&$MPWP, 'modify_footer_admin'));
add_action('admin_print_styles', array(&$MPWP,'wp_admin_styles'));
add_action('admin_footer', array(&$MPWP, 'admin_footer'));
add_action('init', array($MPWP, 'text_translation'));
add_action('wp_print_scripts', array(&$MPWP, 'disableAutoSave'));
add_action('wp_dashboard_setup', array(&$MPWP, 'reconfigure_dashboard'));
add_filter('contextual_help', array(&$MPWP, 'help'), 10, 2);
add_action('admin_notices', array(&$MPWP,'my_admin_notice'));
add_action('admin_notices', array(&$MPWP,'sys_admin_alert'));
endif;

add_filter("the_excerpt", array(&$MPWP, "main_excerpt"));
add_action('wp_print_scripts', array(&$MPWP, 'wp_enqueue_scripts'));
add_action('wp_print_styles', array(&$MPWP, 'wp_enqueue_styles'));
add_action('widgets_init', array(&$MPWP, 'sidebar_widgets'));
add_action('wp_head', array(&$MPWP,'meta_keywords'),3);
add_shortcode('CONTACT FORM', array(&$MPWP,'contact_form'));
add_filter('wp_feed_cache_transient_lifetime', create_function('$a', 'return 300;'));
add_filter( 'wp_default_editor', create_function('', 'return "html";')); //http://wordpress.org/support/topic/qtranslate-broken-after-update-wp-to-35-version

require_once ("functions-widgets.php");

else:

add_action( "admin_notices", array(&$MPWP, 'q8_admin_notice') );

add_action( "template_redirect", create_function( "", "exit( 0 );" ) );

endif;
endif;

?>